/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.retry;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.retry.ActorRetryMechanism;
import io.camunda.zeebe.scheduler.retry.OperationToRetry;
import io.camunda.zeebe.scheduler.retry.RetryStrategy;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndlessRetryStrategy
implements RetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EndlessRetryStrategy.class);
    private final ActorControl actor;
    private final ActorRetryMechanism retryMechanism;
    private CompletableActorFuture<Boolean> currentFuture;
    private BooleanSupplier terminateCondition;

    public EndlessRetryStrategy(ActorControl actor) {
        this.actor = actor;
        this.retryMechanism = new ActorRetryMechanism();
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier condition) {
        this.currentFuture = new CompletableActorFuture();
        this.terminateCondition = condition;
        this.retryMechanism.wrap(callable, this.terminateCondition, this.currentFuture);
        this.actor.run(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            ActorRetryMechanism.Control control = this.retryMechanism.run();
            if (control == ActorRetryMechanism.Control.RETRY) {
                this.actor.run(this::run);
            }
        }
        catch (Exception exception) {
            if (this.terminateCondition.getAsBoolean()) {
                this.currentFuture.complete(false);
            }
            this.actor.run(this::run);
            LOG.error("Caught exception {} with message {}, will retry...", new Object[]{exception.getClass(), exception.getMessage(), exception});
        }
    }
}

