/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorMetricsImpl;
import io.camunda.zeebe.util.CloseableSilently;
import io.micrometer.core.instrument.MeterRegistry;

public interface ActorMetrics {
    public boolean isEnabled();

    public ActorMetricsScoped scoped(String var1);

    public void observeJobSchedulingLatency(long var1, SubscriptionType var3);

    public static ActorMetrics ofNullable(MeterRegistry registry) {
        if (registry == null) {
            return ActorMetrics.disabled();
        }
        return new ActorMetricsImpl(registry);
    }

    public static ActorMetrics disabled() {
        return new ActorMetrics(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public ActorMetricsScoped scoped(String actorName) {
                return ActorMetricsScoped.noop();
            }

            @Override
            public void observeJobSchedulingLatency(long waitTimeNs, SubscriptionType subscriptionType) {
            }
        };
    }

    public static enum SubscriptionType {
        FUTURE("Future"),
        TIMER("Timer"),
        NONE("None");

        private final String name;

        private SubscriptionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface ActorMetricsScoped
    extends CloseableSilently {
        public static final ActorMetricsScoped NOOP = new ActorMetricsScoped(){
            private final CloseableSilently closeable = () -> {};

            public void close() {
            }

            @Override
            public void countExecution() {
            }

            @Override
            public void updateJobQueueLength(int length) {
            }

            @Override
            public CloseableSilently startExecutionTimer() {
                return this.closeable;
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        };

        public void countExecution();

        public void updateJobQueueLength(int var1);

        public CloseableSilently startExecutionTimer();

        public static ActorMetricsScoped noop() {
            return NOOP;
        }

        public boolean isEnabled();
    }
}

