/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.clock;

import io.camunda.zeebe.scheduler.ActorThread;
import java.time.Instant;
import java.time.InstantSource;

public interface ActorClock
extends InstantSource {
    public boolean update();

    public long getTimeMillis();

    public long getNanosSinceLastMillisecond();

    public long getNanoTime();

    public static ActorClock current() {
        ActorThread current = ActorThread.current();
        return current != null ? current.getClock() : null;
    }

    public static long currentTimeMillis() {
        ActorClock clock = ActorClock.current();
        return clock != null ? clock.getTimeMillis() : System.currentTimeMillis();
    }

    @Override
    default public Instant instant() {
        return Instant.ofEpochMilli(this.getTimeMillis());
    }

    @Override
    default public long millis() {
        return this.getTimeMillis();
    }
}

