/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.SnapshotChunkUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Checksum;

final class SnapshotChecksum {
    private SnapshotChecksum() {
        throw new IllegalStateException("Utility class");
    }

    public static long read(Path checksumPath) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "r");){
            long l = checksumFile.readLong();
            return l;
        }
    }

    public static long calculate(Path snapshotDirectory) throws IOException {
        try (Stream<Path> fileStream = Files.list(snapshotDirectory).sorted();){
            long l = SnapshotChecksum.createCombinedChecksum(fileStream.collect(Collectors.toList()));
            return l;
        }
    }

    public static void persist(Path checksumPath, long checksum) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "rwd");){
            checksumFile.writeLong(checksum);
        }
    }

    private static long createCombinedChecksum(List<Path> paths) throws IOException {
        Checksum checksum = SnapshotChunkUtil.newChecksum();
        ByteBuffer readBuffer = ByteBuffer.allocate(4096);
        for (Path path : paths) {
            byte[] chunkId = path.getFileName().toString().getBytes(StandardCharsets.UTF_8);
            checksum.update(chunkId);
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            try {
                readBuffer.clear();
                while (channel.read(readBuffer) > 0) {
                    readBuffer.flip();
                    checksum.update(readBuffer);
                    readBuffer.clear();
                }
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
        return checksum.getValue();
    }
}

