/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotReservation;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotChunkReader;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotReservation;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedSnapshot
implements PersistedSnapshot {
    private static final int VERSION = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedSnapshot.class);
    private final Path directory;
    private final Path checksumFile;
    private final long checksum;
    private final FileBasedSnapshotMetadata metadata;
    private final Consumer<FileBasedSnapshot> onSnapshotDeleted;
    private final Set<FileBasedSnapshotReservation> reservations = new HashSet<FileBasedSnapshotReservation>();
    private final ActorControl actor;
    private boolean deleted = false;

    FileBasedSnapshot(Path directory, Path checksumFile, long checksum, FileBasedSnapshotMetadata metadata, Consumer<FileBasedSnapshot> onSnapshotDeleted, ActorControl actor) {
        this.directory = directory;
        this.checksumFile = checksumFile;
        this.checksum = checksum;
        this.metadata = metadata;
        this.onSnapshotDeleted = onSnapshotDeleted;
        this.actor = actor;
    }

    public FileBasedSnapshotMetadata getMetadata() {
        return this.metadata;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Path getChecksumFile() {
        return this.checksumFile;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public long getIndex() {
        return this.metadata.getIndex();
    }

    @Override
    public long getTerm() {
        return this.metadata.getTerm();
    }

    @Override
    public SnapshotChunkReader newChunkReader() {
        try {
            return new FileBasedSnapshotChunkReader(this.directory, this.checksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Path getPath() {
        return this.getDirectory();
    }

    @Override
    public long getCompactionBound() {
        return this.getIndex();
    }

    @Override
    public String getId() {
        return this.metadata.getSnapshotIdAsString();
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public ActorFuture<SnapshotReservation> reserve() {
        CompletableActorFuture snapshotLocked = new CompletableActorFuture();
        this.actor.run(() -> {
            if (!this.deleted) {
                FileBasedSnapshotReservation reservation = new FileBasedSnapshotReservation(this);
                this.reservations.add(reservation);
                snapshotLocked.complete((Object)reservation);
            } else {
                snapshotLocked.completeExceptionally((Throwable)new SnapshotException.SnapshotNotFoundException(String.format("Expected to reserve snapshot %s, but snapshot is deleted.", this.getId())));
            }
        });
        return snapshotLocked;
    }

    void delete() {
        try {
            Files.deleteIfExists(this.checksumFile);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete snapshot checksum file {}", (Object)this.checksumFile, (Object)e);
        }
        try {
            FileUtil.deleteFolderIfExists((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete snapshot {}", (Object)this.directory, (Object)e);
        }
        this.deleted = true;
        this.onSnapshotDeleted.accept(this);
    }

    public void close() {
    }

    public int hashCode() {
        int result = this.getDirectory().hashCode();
        result = 31 * result + this.checksumFile.hashCode();
        result = 31 * result + (int)(this.getChecksum() ^ this.getChecksum() >>> 32);
        result = 31 * result + this.getMetadata().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedSnapshot that = (FileBasedSnapshot)o;
        if (this.getChecksum() != that.getChecksum()) {
            return false;
        }
        if (!this.getDirectory().equals(that.getDirectory())) {
            return false;
        }
        if (!this.checksumFile.equals(that.checksumFile)) {
            return false;
        }
        return this.getMetadata().equals(that.getMetadata());
    }

    public String toString() {
        return "FileBasedSnapshot{directory=" + this.directory + ", checksumFile=" + this.checksumFile + ", checksum=" + this.checksum + ", metadata=" + this.metadata + "}";
    }

    boolean isReserved() {
        return !this.reservations.isEmpty();
    }

    ActorFuture<Void> removeReservation(FileBasedSnapshotReservation reservation) {
        return this.actor.call(() -> {
            this.reservations.remove(reservation);
            return null;
        });
    }
}

