/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.SnapshotChecksum;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.util.FileUtil;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedTransientSnapshot
implements TransientSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedTransientSnapshot.class);
    private final Path directory;
    private final ActorControl actor;
    private final FileBasedSnapshotStore snapshotStore;
    private final FileBasedSnapshotMetadata metadata;
    private final ActorFuture<Void> takenFuture = new CompletableActorFuture();
    private boolean isValid = false;
    private PersistedSnapshot snapshot;
    private long checksum;

    FileBasedTransientSnapshot(FileBasedSnapshotMetadata metadata, Path directory, FileBasedSnapshotStore snapshotStore, ActorControl actor) {
        this.metadata = metadata;
        this.snapshotStore = snapshotStore;
        this.directory = directory;
        this.actor = actor;
    }

    @Override
    public ActorFuture<Void> take(Consumer<Path> takeSnapshot) {
        this.actor.run(() -> this.takeInternal(takeSnapshot));
        return this.takenFuture;
    }

    private void takeInternal(Consumer<Path> takeSnapshot) {
        block9: {
            SnapshotMetrics snapshotMetrics = this.snapshotStore.getSnapshotMetrics();
            try (Histogram.Timer ignored = snapshotMetrics.startTimer();){
                try {
                    takeSnapshot.accept(this.getPath());
                    if (!this.directory.toFile().exists() || this.directory.toFile().listFiles().length == 0) {
                        this.abortInternal();
                        this.takenFuture.completeExceptionally((Throwable)new IllegalStateException(String.format("Expected to find transient snapshot in directory %s, but the directory is empty or does not exists", this.directory)));
                        break block9;
                    }
                    this.checksum = SnapshotChecksum.calculate(this.directory).getCombinedValue();
                    this.snapshot = null;
                    this.isValid = true;
                    this.takenFuture.complete(null);
                }
                catch (Exception exception) {
                    LOGGER.warn("Unexpected exception on taking snapshot ({})", (Object)this.metadata, (Object)exception);
                    this.abortInternal();
                    this.takenFuture.completeExceptionally((Throwable)exception);
                }
            }
        }
    }

    @Override
    public ActorFuture<Void> abort() {
        CompletableActorFuture abortFuture = new CompletableActorFuture();
        this.actor.run(() -> {
            this.abortInternal();
            abortFuture.complete(null);
        });
        return abortFuture;
    }

    @Override
    public ActorFuture<PersistedSnapshot> persist() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> this.persistInternal((CompletableActorFuture<PersistedSnapshot>)future));
        return future;
    }

    @Override
    public SnapshotId snapshotId() {
        return this.metadata;
    }

    @Override
    public Path getPath() {
        return this.directory;
    }

    private void persistInternal(CompletableActorFuture<PersistedSnapshot> future) {
        if (this.snapshot != null) {
            future.complete((Object)this.snapshot);
            return;
        }
        if (!this.takenFuture.isDone() || this.takenFuture.isCompletedExceptionally()) {
            future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not taken"));
            return;
        }
        if (!this.isValid) {
            future.completeExceptionally((Throwable)new SnapshotException.SnapshotNotFoundException("Snapshot may have been already deleted."));
            return;
        }
        try {
            this.snapshot = this.snapshotStore.newSnapshot(this.metadata, this.directory, this.checksum);
            future.complete((Object)this.snapshot);
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)e);
        }
        this.snapshotStore.removePendingSnapshot(this);
    }

    private void abortInternal() {
        try {
            this.isValid = false;
            this.snapshot = null;
            LOGGER.debug("Aborting transient snapshot {}", (Object)this);
            FileUtil.deleteFolderIfExists((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete pending snapshot {}", (Object)this, (Object)e);
        }
        finally {
            this.snapshotStore.removePendingSnapshot(this);
        }
    }

    public String toString() {
        return "FileBasedTransientSnapshot{directory=" + this.directory + ", checksum=" + this.checksum + ", metadata=" + this.metadata + "}";
    }
}

