/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;

final class SfvChecksum {
    private static final String FILE_CRC_SEPARATOR = "   ";
    private static final String FILE_CRC_SEPARATOR_REGEX = " {3}";
    private static final Pattern FILE_CRC_PATTERN = Pattern.compile("(.*) {3}([0-9a-fA-F]{1,16})");
    private static final String COMBINED_VALUE_PREFIX = "; combinedValue = ";
    private static final Pattern COMBINED_VALUE_PATTERN = Pattern.compile(".*combinedValue\\s+=\\s+([0-9a-fA-F]{1,16})");
    private static final String SNAPSHOT_DIRECTORY_PREFIX = "; snapshot directory = ";
    private Checksum combinedChecksum;
    private final SortedMap<String, Long> checksums = new TreeMap<String, Long>();
    private String snapshotDirectoryComment;

    public SfvChecksum(long combinedChecksum) {
        this.combinedChecksum = new PreDefinedImmutableChecksum(combinedChecksum);
    }

    public SfvChecksum() {
        this.combinedChecksum = new CRC32C();
    }

    public long getCombinedValue() {
        return this.combinedChecksum.getValue();
    }

    public void setSnapshotDirectoryComment(String headerComment) {
        this.snapshotDirectoryComment = headerComment;
    }

    public String toString() {
        return "SfvChecksum{combinedChecksum=" + this.combinedChecksum.getValue() + ", checksums=" + this.checksums + "}";
    }

    public void updateFromFile(Path filePath) throws IOException {
        String fileName = filePath.getFileName().toString();
        byte[] chunkId = fileName.getBytes(StandardCharsets.UTF_8);
        this.combinedChecksum.update(chunkId);
        CRC32C checksum = new CRC32C();
        ByteBuffer readBuffer = ByteBuffer.allocate(4096);
        try (FileChannel channel = FileChannel.open(filePath, StandardOpenOption.READ);){
            readBuffer.clear();
            while (channel.read(readBuffer) > 0) {
                readBuffer.flip();
                this.combinedChecksum.update(readBuffer);
                readBuffer.flip();
                checksum.update(readBuffer);
                readBuffer.clear();
            }
        }
        this.checksums.put(fileName, checksum.getValue());
    }

    public void updateFromSfvFile(String ... lines) {
        for (String line : lines) {
            Matcher matcher;
            if ((line = line.trim()).startsWith(";")) {
                matcher = COMBINED_VALUE_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                String hexString = matcher.group(1);
                long crc = Long.parseLong(hexString, 16);
                this.combinedChecksum = new PreDefinedImmutableChecksum(crc);
                continue;
            }
            matcher = FILE_CRC_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            Long crc = Long.parseLong(matcher.group(2), 16);
            String fileName = matcher.group(1).trim();
            this.checksums.put(fileName, crc);
        }
    }

    byte[] serializeSfvFileData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
        writer.write("; This is an SFC checksum file for all files in the given directory.");
        writer.newLine();
        writer.write("; You might use cksfv or another tool to validate these files manually.");
        writer.newLine();
        writer.write("; This is an automatically created file - please do NOT modify.");
        writer.newLine();
        if (this.snapshotDirectoryComment != null) {
            writer.write(SNAPSHOT_DIRECTORY_PREFIX);
            writer.write(this.snapshotDirectoryComment);
            writer.newLine();
        }
        writer.write(COMBINED_VALUE_PREFIX);
        writer.write(Long.toHexString(this.combinedChecksum.getValue()));
        writer.newLine();
        writer.write("; number of files used for combined value = " + this.checksums.size());
        writer.newLine();
        for (Map.Entry<String, Long> entry : this.checksums.entrySet()) {
            writer.write(entry.getKey());
            writer.write(FILE_CRC_SEPARATOR);
            writer.write(Long.toHexString(entry.getValue()));
            writer.newLine();
        }
        writer.flush();
        return baos.toByteArray();
    }

    private static class PreDefinedImmutableChecksum
    implements Checksum {
        private final long crc;

        public PreDefinedImmutableChecksum(long crc) {
            this.crc = crc;
        }

        @Override
        public void update(int b) {
            throw PreDefinedImmutableChecksum.getUnsupportedOperationException();
        }

        @Override
        public void update(byte[] b, int off, int len) {
            throw PreDefinedImmutableChecksum.getUnsupportedOperationException();
        }

        @Override
        public long getValue() {
            return this.crc;
        }

        @Override
        public void reset() {
            throw PreDefinedImmutableChecksum.getUnsupportedOperationException();
        }

        private static UnsupportedOperationException getUnsupportedOperationException() {
            return new UnsupportedOperationException("This is an immutable checksum.");
        }
    }
}

