/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.snapshots.RestorableSnapshotStore;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public final class FileBasedSnapshotStoreFactory
implements ReceivableSnapshotStoreFactory {
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    public static final String PENDING_DIRECTORY = "pending";
    private final ConcurrentHashMap<Integer, FileBasedSnapshotStore> partitionSnapshotStores = new ConcurrentHashMap();
    private final ActorSchedulingService actorScheduler;
    private final int nodeId;

    public FileBasedSnapshotStoreFactory(ActorSchedulingService actorScheduler, int nodeId) {
        this.actorScheduler = actorScheduler;
        this.nodeId = nodeId;
    }

    public static RestorableSnapshotStore createRestorableSnapshotStore(Path root, int partitionId, int nodeId) {
        return FileBasedSnapshotStoreFactory.createSnapshotStoreWithoutOpening(root, partitionId, nodeId);
    }

    private static FileBasedSnapshotStore createSnapshotStoreWithoutOpening(Path root, int partitionId, int nodeId) {
        Path snapshotDirectory = root.resolve(SNAPSHOTS_DIRECTORY);
        Path pendingDirectory = root.resolve(PENDING_DIRECTORY);
        try {
            FileUtil.ensureDirectoryExists((Path)snapshotDirectory);
            FileUtil.ensureDirectoryExists((Path)pendingDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create snapshot directories", e);
        }
        return new FileBasedSnapshotStore(partitionId, new SnapshotMetrics(Integer.toString(partitionId)), snapshotDirectory, pendingDirectory);
    }

    @Override
    public ReceivableSnapshotStore createReceivableSnapshotStore(Path root, int partitionId) {
        return this.partitionSnapshotStores.computeIfAbsent(partitionId, p -> {
            FileBasedSnapshotStore snapshotStore = FileBasedSnapshotStoreFactory.createSnapshotStoreWithoutOpening(root, partitionId, this.nodeId);
            this.actorScheduler.submitActor((Actor)snapshotStore, SchedulingHints.ioBound()).join();
            return snapshotStore;
        });
    }

    public ConstructableSnapshotStore getConstructableSnapshotStore(int partitionId) {
        return this.partitionSnapshotStores.get(partitionId);
    }

    public ReceivableSnapshotStore getReceivableSnapshotStore(int partitionId) {
        return this.partitionSnapshotStores.get(partitionId);
    }

    public PersistedSnapshotStore getPersistedSnapshotStore(int partitionId) {
        return this.partitionSnapshotStores.get(partitionId);
    }

    @Deprecated
    public ConcurrencyControl getSnapshotStoreConcurrencyControl(int partitionId) {
        FileBasedSnapshotStore snapshotStore = this.partitionSnapshotStores.get(partitionId);
        if (snapshotStore == null) {
            throw new NoSuchElementException("No snapshot store found for partition " + partitionId);
        }
        return snapshotStore;
    }
}

