/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.MutableChecksumsSFV;
import io.camunda.zeebe.snapshots.impl.SfvChecksumImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

final class SnapshotChecksum {
    private SnapshotChecksum() {
        throw new IllegalStateException("Utility class");
    }

    public static ImmutableChecksumsSFV read(Path checksumPath) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "r");){
            String line;
            if (checksumFile.length() == 8L) {
                long combinedChecksum = checksumFile.readLong();
                SfvChecksumImpl sfvChecksumImpl = new SfvChecksumImpl(combinedChecksum);
                return sfvChecksumImpl;
            }
            SfvChecksumImpl sfvChecksum = new SfvChecksumImpl();
            while ((line = checksumFile.readLine()) != null) {
                sfvChecksum.updateFromSfvFile(line);
            }
            SfvChecksumImpl sfvChecksumImpl = sfvChecksum;
            return sfvChecksumImpl;
        }
    }

    public static MutableChecksumsSFV calculate(Path snapshotDirectory) throws IOException {
        try (Stream<Path> fileStream = Files.list(snapshotDirectory).filter(SnapshotChecksum::isNotMetadataFile).sorted();){
            SfvChecksumImpl sfvChecksum = SnapshotChecksum.createCombinedChecksum(fileStream);
            Path metadataFile = snapshotDirectory.resolve("zeebe.metadata");
            if (metadataFile.toFile().exists()) {
                sfvChecksum.updateFromFile(metadataFile);
            }
            SfvChecksumImpl sfvChecksumImpl = sfvChecksum;
            return sfvChecksumImpl;
        }
    }

    private static boolean isNotMetadataFile(Path file) {
        return !file.getFileName().toString().equals("zeebe.metadata");
    }

    public static void persist(Path checksumPath, ImmutableChecksumsSFV checksum) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(checksumPath.toFile());){
            checksum.write(stream);
        }
    }

    private static SfvChecksumImpl createCombinedChecksum(Stream<Path> files) {
        SfvChecksumImpl checksum = new SfvChecksumImpl();
        files.forEachOrdered(path -> {
            try {
                checksum.updateFromFile((Path)path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return checksum;
    }
}

