/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum SnapshotMetricsDoc implements ExtendedMeterDocumentation
{
    SNAPSHOT_COUNT{

        public String getDescription() {
            return "Total count of committed snapshots on disk";
        }

        public String getName() {
            return "zeebe.snapshot.count";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    SNAPSHOT_SIZE{

        public String getDescription() {
            return "Estimated snapshot size on disk";
        }

        public String getName() {
            return "zeebe.snapshot.size.bytes";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    SNAPSHOT_CHUNK_COUNT{

        public String getDescription() {
            return "Number of chunks in the last snapshot";
        }

        public String getName() {
            return "zeebe.snapshot.chunks.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    SNAPSHOT_DURATION{

        public String getDescription() {
            return "Approximate duration of snapshot operation";
        }

        public String getName() {
            return "zeebe.snapshot.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    SNAPSHOT_PERSIST_DURATION{

        public String getDescription() {
            return "Approximate duration of snapshot persist operation";
        }

        public String getName() {
            return "zeebe.snapshot.persist.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    SNAPSHOT_FILE_SIZE{
        private static final double[] BUCKETS = new double[]{0.01, 0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0};

        public String getDescription() {
            return "Approximate size of snapshot files";
        }

        public String getName() {
            return "zeebe.snapshot.file.size.megabytes";
        }

        public String getBaseUnit() {
            return "MB";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }

        public KeyName[] getKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }

        public double[] getDistributionSLOs() {
            return BUCKETS;
        }
    };

}

