/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.ChecksumProvider;
import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.MutableChecksumsSFV;
import io.camunda.zeebe.snapshots.impl.SfvChecksumImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.stream.Stream;

final class SnapshotChecksum {
    private SnapshotChecksum() {
        throw new IllegalStateException("Utility class");
    }

    public static ImmutableChecksumsSFV read(Path checksumPath) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "r");){
            String line;
            if (checksumFile.length() == 8L) {
                long combinedChecksum = checksumFile.readLong();
                SfvChecksumImpl sfvChecksumImpl = new SfvChecksumImpl(combinedChecksum);
                return sfvChecksumImpl;
            }
            SfvChecksumImpl sfvChecksum = new SfvChecksumImpl();
            while ((line = checksumFile.readLine()) != null) {
                sfvChecksum.updateFromSfvFile(line);
            }
            SfvChecksumImpl sfvChecksumImpl = sfvChecksum;
            return sfvChecksumImpl;
        }
    }

    public static MutableChecksumsSFV calculate(Path snapshotDirectory) throws IOException {
        return SnapshotChecksum.createChecksumForSnapshot(snapshotDirectory, snapshotPath -> Map.of());
    }

    public static MutableChecksumsSFV calculateWithProvidedChecksums(Path snapshotDirectory, ChecksumProvider provider) throws IOException {
        return SnapshotChecksum.createChecksumForSnapshot(snapshotDirectory, provider);
    }

    private static MutableChecksumsSFV createChecksumForSnapshot(Path snapshotDirectory, ChecksumProvider provider) throws IOException {
        try (Stream<Path> fileStream = Files.list(snapshotDirectory).filter(SnapshotChecksum::isNotMetadataFile).sorted();){
            SfvChecksumImpl sfvChecksum = new SfvChecksumImpl();
            Map<String, Long> fullFileChecksums = provider.getSnapshotChecksums(snapshotDirectory);
            fileStream.forEachOrdered(path -> SnapshotChecksum.updateChecksum(sfvChecksum, fullFileChecksums, path));
            Path metadataFile = snapshotDirectory.resolve("zeebe.metadata");
            if (metadataFile.toFile().exists()) {
                sfvChecksum.updateFromFile(metadataFile);
            }
            SfvChecksumImpl sfvChecksumImpl = sfvChecksum;
            return sfvChecksumImpl;
        }
    }

    private static boolean isNotMetadataFile(Path file) {
        return !file.getFileName().toString().equals("zeebe.metadata");
    }

    public static void persist(Path checksumPath, ImmutableChecksumsSFV checksum) throws IOException {
        try (FileChannel channel = FileChannel.open(checksumPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             OutputStream output = Channels.newOutputStream(channel);){
            checksum.write(output);
            channel.force(true);
        }
    }

    private static void updateChecksum(MutableChecksumsSFV checksum, Map<String, Long> fullFileChecksums, Path file) {
        String fileName = file.getFileName().toString();
        if (fullFileChecksums.containsKey(fileName)) {
            checksum.updateFromChecksum(file, fullFileChecksums.get(fileName));
        } else {
            try {
                checksum.updateFromFile(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

