/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.protocol.Protocol;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public record SnapshotChunkId(ByteBuffer id) {
    private static final Charset ID_CHARSET = StandardCharsets.US_ASCII;

    SnapshotChunkId(String fileName, long offset) {
        this(ByteBuffer.wrap((fileName + "__" + offset).getBytes(ID_CHARSET)).order(Protocol.ENDIANNESS));
    }

    public String fileName() {
        String fileName = ID_CHARSET.decode(this.id()).toString().split("__")[0];
        this.id.clear();
        return fileName;
    }

    public long offset() {
        Long offset = Long.valueOf(ID_CHARSET.decode(this.id()).toString().split("__")[1]);
        this.id.clear();
        return offset;
    }

    @Override
    public String toString() {
        String idStr = ID_CHARSET.decode(this.id).toString();
        this.id.clear();
        return idStr;
    }
}

