/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.MutableRecordBatch;
import io.camunda.zeebe.stream.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.stream.api.scheduling.ScheduledCommandCache;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import io.camunda.zeebe.stream.impl.records.RecordBatch;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;

public final class BufferedTaskResultBuilder
implements TaskResultBuilder {
    private final MutableRecordBatch mutableRecordBatch;
    private final ScheduledCommandCache.StagedScheduledCommandCache cache;

    public BufferedTaskResultBuilder(RecordBatchSizePredicate predicate, ScheduledCommandCache.StagedScheduledCommandCache cache) {
        this.mutableRecordBatch = new RecordBatch(predicate);
        this.cache = cache;
    }

    @Override
    public boolean appendCommandRecord(long key, Intent intent, UnifiedRecordValue value) {
        ValueType valueType = TypedEventRegistry.TYPE_REGISTRY.get(value.getClass());
        if (valueType == null) {
            throw new IllegalStateException("Missing value type mapping for record: " + value.getClass());
        }
        if (this.cache.contains(intent, key)) {
            return true;
        }
        RecordMetadata metadata = new RecordMetadata().recordType(RecordType.COMMAND).intent(intent).rejectionType(RejectionType.NULL_VAL).rejectionReason("").valueType(valueType);
        Either<RuntimeException, Void> either = this.mutableRecordBatch.appendRecord(key, metadata, -1, (BufferWriter)value);
        either.ifRight(ok -> this.cache.add(intent, key));
        return either.isRight();
    }

    @Override
    public TaskResult build() {
        return () -> this.mutableRecordBatch;
    }
}

