/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.SimpleProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import java.time.Duration;

public class ExtendedProcessingScheduleServiceImpl
implements ProcessingScheduleService {
    private final SimpleProcessingScheduleService processorActorService;
    private final SimpleProcessingScheduleService asyncActorService;
    private final ConcurrencyControl concurrencyControl;
    private final boolean alwaysAsync;

    public ExtendedProcessingScheduleServiceImpl(SimpleProcessingScheduleService processorActorService, SimpleProcessingScheduleService asyncActorService, ConcurrencyControl concurrencyControl, boolean alwaysAsync) {
        this.processorActorService = processorActorService;
        this.asyncActorService = asyncActorService;
        this.concurrencyControl = concurrencyControl;
        this.alwaysAsync = alwaysAsync;
    }

    @Override
    public void runAtFixedRateAsync(Duration delay, Task task) {
        this.concurrencyControl.run(() -> this.asyncActorService.runAtFixedRate(delay, task));
    }

    @Override
    public void runDelayedAsync(Duration delay, Task task) {
        this.concurrencyControl.run(() -> this.asyncActorService.runDelayed(delay, task));
    }

    @Override
    public void runDelayed(Duration delay, Runnable task) {
        if (this.alwaysAsync) {
            this.concurrencyControl.run(() -> this.asyncActorService.runDelayed(delay, task));
        } else {
            this.processorActorService.runDelayed(delay, task);
        }
    }

    @Override
    public void runDelayed(Duration delay, Task task) {
        if (this.alwaysAsync) {
            this.runDelayedAsync(delay, task);
        } else {
            this.processorActorService.runDelayed(delay, task);
        }
    }

    @Override
    public void runAtFixedRate(Duration delay, Task task) {
        if (this.alwaysAsync) {
            this.runAtFixedRateAsync(delay, task);
        } else {
            this.processorActorService.runAtFixedRate(delay, task);
        }
    }
}

