/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.RecordProcessor;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.scheduling.ScheduledCommandCache;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.StreamProcessorContext;
import io.camunda.zeebe.stream.impl.StreamProcessorListener;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class StreamProcessorBuilder {
    private final StreamProcessorContext streamProcessorContext;
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private ActorSchedulingService actorSchedulingService;
    private ZeebeDb zeebeDb;
    private int nodeId;
    private List<RecordProcessor> recordProcessors;
    private ScheduledCommandCache.StageableScheduledCommandCache scheduledCommandCache = new ScheduledCommandCache.NoopScheduledCommandCache();

    public StreamProcessorBuilder() {
        this.streamProcessorContext = new StreamProcessorContext();
    }

    public StreamProcessorBuilder recordProcessors(List<RecordProcessor> recordProcessors) {
        this.recordProcessors = recordProcessors;
        return this;
    }

    public StreamProcessorBuilder actorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    public StreamProcessorBuilder nodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public StreamProcessorBuilder logStream(LogStream stream) {
        this.streamProcessorContext.logStream(stream);
        return this;
    }

    public StreamProcessorBuilder commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.streamProcessorContext.commandResponseWriter(commandResponseWriter);
        return this;
    }

    public StreamProcessorBuilder listener(StreamProcessorListener listener) {
        this.streamProcessorContext.listener(listener);
        return this;
    }

    public StreamProcessorBuilder zeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
        return this;
    }

    public StreamProcessorBuilder streamProcessorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorContext.processorMode(streamProcessorMode);
        return this;
    }

    public StreamProcessorBuilder partitionCommandSender(InterPartitionCommandSender interPartitionCommandSender) {
        this.streamProcessorContext.partitionCommandSender(interPartitionCommandSender);
        return this;
    }

    public StreamProcessorContext getProcessingContext() {
        return this.streamProcessorContext;
    }

    public ActorSchedulingService getActorSchedulingService() {
        return this.actorSchedulingService;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return Collections.unmodifiableList(this.lifecycleListeners);
    }

    public void addLifecycleListener(StreamProcessorLifecycleAware lifecycleAware) {
        this.lifecycleListeners.add(lifecycleAware);
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public List<RecordProcessor> getRecordProcessors() {
        return this.recordProcessors;
    }

    public StreamProcessorBuilder scheduledCommandCache(ScheduledCommandCache.StageableScheduledCommandCache scheduledCommandCache) {
        this.scheduledCommandCache = scheduledCommandCache;
        return this;
    }

    public ScheduledCommandCache.StageableScheduledCommandCache scheduledCommandCache() {
        return this.scheduledCommandCache;
    }

    public StreamProcessor build() {
        this.validate();
        return new StreamProcessor(this);
    }

    private void validate() {
        Objects.requireNonNull(this.actorSchedulingService, "No task scheduler provided.");
        Objects.requireNonNull(this.streamProcessorContext.getLogStream(), "No log stream provided.");
        Objects.requireNonNull(this.zeebeDb, "No database provided.");
        if (this.streamProcessorContext.getProcessorMode() == StreamProcessorMode.PROCESSING) {
            Objects.requireNonNull(this.streamProcessorContext.getPartitionCommandSender(), "No partition command sender provided");
        }
        if (this.streamProcessorContext.getMaxCommandsInBatch() < 1) {
            throw new IllegalArgumentException("Batch processing limit must be >= 1 but was %s".formatted(this.streamProcessorContext.getMaxCommandsInBatch()));
        }
    }

    public StreamProcessorBuilder maxCommandsInBatch(int maxCommandsInBatch) {
        this.streamProcessorContext.maxCommandsInBatch(maxCommandsInBatch);
        return this;
    }

    public StreamProcessorBuilder setEnableAsyncScheduledTasks(boolean enabled) {
        this.streamProcessorContext.setEnableAsyncScheduledTasks(enabled);
        return this;
    }
}

