/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;

public enum StreamMetricsDoc implements ExtendedMeterDocumentation
{
    BATCH_PROCESSING_DURATION{
        private static final Duration[] BUCKETS = new Duration[]{Duration.ofNanos(100000L), Duration.ofMillis(1L), Duration.ofMillis(10L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(2L)};

        public String getDescription() {
            return "Time spent in batch processing (in seconds)";
        }

        public String getName() {
            return "zeebe.stream.processor.batch.processing.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }
    }
    ,
    BATCH_PROCESSING_COMMANDS{
        private static final double[] BUCKETS = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0};

        public String getDescription() {
            return "Records the distribution of commands in a batch over time";
        }

        public String getName() {
            return "zeebe.stream.processor.batch.processing.commands";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }

        public double[] getDistributionSLOs() {
            return BUCKETS;
        }
    }
    ,
    BATCH_PROCESSING_POST_COMMIT_TASKS{
        private static final Duration[] BUCKETS = new Duration[]{Duration.ofNanos(100000L), Duration.ofMillis(1L), Duration.ofMillis(10L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(2L)};

        public String getDescription() {
            return "Time spent in executing post commit tasks after batch processing (in seconds)";
        }

        public String getName() {
            return "zeebe.stream.processor.batch.processing.post.commit.tasks";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }
    }
    ,
    BATCH_PROCESSING_RETRIES{

        public String getDescription() {
            return "Number of times batch processing failed due to reaching batch limit and was retried";
        }

        public String getName() {
            return "zeebe.stream.processor.batch.processing.retry";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }
    }
    ,
    ERROR_HANDLING_PHASE{

        public String getDescription() {
            return "The current phase of error handling the processor is in";
        }

        public String getName() {
            return "zeebe.stream.processor.error.handling.phase";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return ErrorHandlingPhaseKeys.values();
        }
    }
    ,
    REPLAY_EVENTS_COUNT{

        public String getDescription() {
            return "Number of events replayed by the stream processor";
        }

        public String getName() {
            return "zeebe.replay.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }
    }
    ,
    LAST_SOURCE_POSITION{

        public String getDescription() {
            return "The last source position the stream processor has replayed";
        }

        public String getName() {
            return "zeebe.replay.last.source.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    REPLAY_DURATION{

        public String getDescription() {
            return "Time for replay a batch of events (in seconds)";
        }

        public String getName() {
            return "zeebe.replay.event.batch.replay.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    STREAM_PROCESSOR_EVENTS{

        public String getDescription() {
            return "Number of records processed by stream processor";
        }

        public String getName() {
            return "zeebe.stream.processor.records.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return StreamProcessorActionKeys.values();
        }
    }
    ,
    LAST_PROCESSED_POSITION{

        public String getDescription() {
            return "The last position the stream processor has processed";
        }

        public String getName() {
            return "zeebe.stream.processor.last.processed.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    PROCESSING_LATENCY{

        public String getDescription() {
            return "Time between a command is written until it is picked up for processing (in seconds)";
        }

        public String getName() {
            return "zeebe.stream.processor.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    PROCESSING_DURATION{

        public String getDescription() {
            return "Time for processing a record (in seconds)";
        }

        public String getName() {
            return "zeebe.stream.processor.processing.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    STARTUP_RECOVERY_TIME{

        public String getDescription() {
            return "Time taken for startup and recovery of stream processor (in ms)";
        }

        public String getName() {
            return "zeebe.stream.processor.startup.recovery.time";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    };


    public static enum ProcessingDurationKeys implements KeyName
    {
        VALUE_TYPE{

            public String asString() {
                return "valueType";
            }
        }
        ,
        INTENT{

            public String asString() {
                return "intent";
            }
        };

    }

    public static enum StreamProcessorActionKeys implements KeyName
    {
        ACTION{

            public String asString() {
                return "action";
            }
        };

    }

    public static enum ErrorHandlingPhaseKeys implements KeyName
    {
        ERROR_HANDLING_PHASE{

            public String asString() {
                return "zeebe_stream_processor_error_handling_phase";
            }
        };

    }
}

