/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.stream.impl.metrics.StreamMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class StreamProcessorMetrics {
    private final AtomicLong startupRecoveryTime = new AtomicLong();
    private final MeterRegistry registry;

    public StreamProcessorMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.registerStartupRecoveryTime();
    }

    public CloseableSilently startRecoveryTimer() {
        return MicrometerUtil.timer(this.startupRecoveryTime::set, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)this.registry.config().clock());
    }

    private void registerStartupRecoveryTime() {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.STARTUP_RECOVERY_TIME;
        TimeGauge.builder((String)meterDoc.getName(), (Object)this.startupRecoveryTime, (TimeUnit)TimeUnit.MILLISECONDS, AtomicLong::longValue).description(meterDoc.getDescription()).register(this.registry);
    }
}

