/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.api.scheduling;

import io.camunda.zeebe.protocol.record.intent.Intent;

public interface ScheduledCommandCache {
    public void add(Intent var1, long var2);

    public boolean contains(Intent var1, long var2);

    public void remove(Intent var1, long var2);

    public void clear();

    public static interface StagedScheduledCommandCache
    extends ScheduledCommandCache,
    ScheduledCommandCacheChanges {
    }

    public static interface StageableScheduledCommandCache
    extends ScheduledCommandCache {
        public StagedScheduledCommandCache stage();
    }

    public static interface ScheduledCommandCacheChanges {
        public void persist();

        public void rollback();
    }

    public static final class NoopScheduledCommandCache
    implements StageableScheduledCommandCache,
    StagedScheduledCommandCache {
        @Override
        public void persist() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void add(Intent intent, long key) {
        }

        @Override
        public boolean contains(Intent intent, long key) {
            return false;
        }

        @Override
        public void remove(Intent intent, long key) {
        }

        @Override
        public void clear() {
        }

        @Override
        public StagedScheduledCommandCache stage() {
            return this;
        }
    }
}

