/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.RecordProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.stream.api.state.KeyGeneratorControls;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RecordProcessorContextImpl
implements RecordProcessorContext {
    private final int partitionId;
    private final ProcessingScheduleService scheduleService;
    private final ZeebeDb zeebeDb;
    private final TransactionContext transactionContext;
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private final InterPartitionCommandSender partitionCommandSender;
    private final KeyGenerator keyGenerator;
    private final MeterRegistry meterRegistry;

    public RecordProcessorContextImpl(int partitionId, ProcessingScheduleService scheduleService, ZeebeDb zeebeDb, TransactionContext transactionContext, InterPartitionCommandSender partitionCommandSender, KeyGeneratorControls keyGeneratorControls, MeterRegistry meterRegistry) {
        this.partitionId = partitionId;
        this.scheduleService = scheduleService;
        this.zeebeDb = zeebeDb;
        this.transactionContext = transactionContext;
        this.partitionCommandSender = partitionCommandSender;
        this.keyGenerator = keyGeneratorControls;
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "must specify a metrics registry");
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public void addLifecycleListeners(List<StreamProcessorLifecycleAware> lifecycleListeners) {
        this.lifecycleListeners.addAll(lifecycleListeners);
    }

    @Override
    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }
}

