/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.api;

import io.camunda.zeebe.stream.impl.ControllableStreamClockImpl;
import io.camunda.zeebe.stream.impl.UncontrolledStreamClock;
import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;

public interface StreamClock
extends InstantSource {
    public static StreamClock uncontrolled(InstantSource source) {
        return new UncontrolledStreamClock(source);
    }

    public static StreamClock system() {
        return StreamClock.uncontrolled(InstantSource.system());
    }

    public static ControllableStreamClock controllable(InstantSource source) {
        return new ControllableStreamClockImpl(source);
    }

    public ControllableStreamClock.Modification currentModification();

    public static interface ControllableStreamClock
    extends StreamClock {
        public void applyModification(Modification var1);

        default public void pinAt(Instant at) {
            this.applyModification(Modification.pinAt(at));
        }

        default public void offsetBy(Duration by) {
            this.applyModification(Modification.offsetBy(by));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        default public void stackOffset(Duration additionalOffset) {
            Modification modification = this.currentModification();
            if (!(modification instanceof Modification.Offset)) {
                this.offsetBy(additionalOffset);
                return;
            }
            Modification.Offset offset = (Modification.Offset)modification;
            try {
                Duration duration;
                Duration initialOffset = duration = offset.by();
                this.applyModification(Modification.offsetBy(initialOffset.plus(additionalOffset)));
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        default public void reset() {
            this.applyModification(Modification.none());
        }

        default public boolean isModified() {
            return !(this.currentModification() instanceof Modification.None);
        }

        public static sealed interface Modification {
            public static None none() {
                return new None();
            }

            public static Pin pinAt(Instant at) {
                return new Pin(at);
            }

            public static Offset offsetBy(Duration by) {
                return new Offset(by);
            }

            public record None() implements Modification
            {
            }

            public record Pin(Instant at) implements Modification
            {
            }

            public record Offset(Duration by) implements Modification
            {
            }
        }
    }
}

