/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test;

import io.camunda.zeebe.client.ZeebeClient;
import java.time.Duration;
import java.util.Properties;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;

public class ClientRule
extends ExternalResource {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(2L);
    protected final Supplier<Properties> properties;
    protected ZeebeClient client;

    public ClientRule() {
        this(Properties::new);
    }

    public ClientRule(Supplier<Properties> propertiesProvider) {
        this.properties = propertiesProvider;
    }

    public ZeebeClient getClient() {
        return this.client;
    }

    protected void before() {
        this.createClient();
    }

    protected void after() {
        this.destroyClient();
    }

    public void createClient() {
        this.client = ZeebeClient.newClientBuilder().defaultRequestTimeout(DEFAULT_REQUEST_TIMEOUT).withProperties(this.properties.get()).build();
    }

    public void destroyClient() {
        this.client.close();
        this.client = null;
    }
}

