/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test;

import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstances;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.stream.StreamWrapperException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;

public class ProcessInstanceAssert
extends AbstractAssert<ProcessInstanceAssert, ProcessInstanceEvent> {
    private static final ZeebeObjectMapper OBJECT_MAPPER = new ZeebeObjectMapper();
    private static final List<ProcessInstanceIntent> ELEMENT_PASSED_INTENTS = Arrays.asList(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN);
    private static final List<ProcessInstanceIntent> INSTANCE_ENDED_INTENTS = Arrays.asList(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATED);
    private final long processInstanceKey;

    public ProcessInstanceAssert(ProcessInstanceEvent actual) {
        super((Object)actual, ProcessInstanceAssert.class);
        this.processInstanceKey = actual.getProcessInstanceKey();
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent actual) {
        return new ProcessInstanceAssert(actual);
    }

    public ProcessInstanceAssert isEnded() {
        boolean isEnded = this.exists((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).withRecordKey(this.processInstanceKey)).filter(ProcessInstanceAssert.intent(INSTANCE_ENDED_INTENTS)));
        if (!isEnded) {
            this.failWithMessage("Expected process instance to be <ended> but was <active>", new Object[0]);
        }
        return this;
    }

    public ProcessInstanceAssert hasPassed(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List passedElements = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).filter(ProcessInstanceAssert.intent(ELEMENT_PASSED_INTENTS))).filter(ProcessInstanceAssert.elementId(ids))).map(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (passedElements.size() < ids.size()) {
            ArrayList<String> notPassed = new ArrayList<String>(ids);
            notPassed.removeAll(passedElements);
            this.failWithMessage("Expected <%s> to be passed but could not find <%s>", new Object[]{ids, notPassed});
        }
        return this;
    }

    public ProcessInstanceAssert hasEntered(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List enteredElements = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(this.processInstanceKey).filter(ProcessInstanceAssert.elementId(ids))).map(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (enteredElements.size() < ids.size()) {
            ArrayList<String> notEntered = new ArrayList<String>(ids);
            notEntered.removeAll(enteredElements);
            this.failWithMessage("Expected <%s> to be entered but could not find <%s>", new Object[]{ids, notEntered});
        }
        return this;
    }

    public ProcessInstanceAssert hasCompleted(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List completedElements = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(this.processInstanceKey).filter(ProcessInstanceAssert.elementId(ids))).map(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (completedElements.size() < ids.size()) {
            ArrayList<String> notCompleted = new ArrayList<String>(ids);
            notCompleted.removeAll(completedElements);
            this.failWithMessage("Expected <%s> to be completed but could not find <%s>", new Object[]{ids, notCompleted});
        }
        return this;
    }

    public ProcessInstanceAssert hasVariable(String key, Object expectedValue) {
        Optional record = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).withRecordKey(this.processInstanceKey)).filter(ProcessInstanceAssert.intent(INSTANCE_ENDED_INTENTS))).findFirst();
        if (record.isPresent()) {
            this.hasVariable((Record<ProcessInstanceRecordValue>)((Record)record.get()), key, expectedValue);
        } else {
            this.failWithMessage("Expected process instance to contain variables but instance is not ended", new Object[0]);
        }
        return this;
    }

    private ProcessInstanceAssert hasVariable(Record<ProcessInstanceRecordValue> record, String key, Object expectedValue) {
        Map variables = ProcessInstances.getCurrentVariables((long)this.processInstanceKey, (long)record.getPosition());
        if (!variables.containsKey(key)) {
            this.failWithMessage("Expected variables <%s> to contain <%s> but could not find entry", new Object[]{variables, key});
            return this;
        }
        Object value = OBJECT_MAPPER.fromJson((String)variables.get(key), Object.class);
        if (expectedValue == null && value != null || expectedValue != null && !expectedValue.equals(value)) {
            this.failWithMessage("Expected variables value of <%s> to be <%s> but was <%s>", new Object[]{key, expectedValue, value});
        }
        return this;
    }

    private boolean exists(ProcessInstanceRecordStream stream) {
        try {
            return stream.exists();
        }
        catch (StreamWrapperException e) {
            return false;
        }
    }

    private static Predicate<Record<ProcessInstanceRecordValue>> intent(List<ProcessInstanceIntent> intents) {
        return record -> intents.contains(record.getIntent());
    }

    private static Predicate<Record<ProcessInstanceRecordValue>> elementId(List<String> elementIds) {
        return record -> {
            String elementId = ((ProcessInstanceRecordValue)record.getValue()).getElementId();
            return elementIds.contains(elementId);
        };
    }
}

