/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.test.ClientRule;
import io.camunda.zeebe.test.EmbeddedBrokerRule;
import io.camunda.zeebe.test.ProcessInstanceAssert;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated(since="1.3.0", forRemoval=true)
public class ZeebeTestRule
extends ExternalResource {
    protected final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final EmbeddedBrokerRule brokerRule;
    private final ClientRule clientRule;

    public ZeebeTestRule() {
        this("zeebe.test.cfg.yaml", Properties::new);
    }

    public ZeebeTestRule(String configFileClasspathLocation, Supplier<Properties> propertiesProvider) {
        this.brokerRule = new EmbeddedBrokerRule(configFileClasspathLocation, new Consumer[0]);
        this.clientRule = new ClientRule(() -> {
            Properties properties = (Properties)propertiesProvider.get();
            properties.setProperty("zeebe.client.gateway.address", NetUtil.toSocketAddressString((InetSocketAddress)this.brokerRule.getGatewayAddress()));
            properties.putIfAbsent("zeebe.client.security.plaintext", "true");
            return properties;
        });
    }

    public ZeebeClient getClient() {
        return this.clientRule.getClient();
    }

    public BrokerCfg getBrokerCfg() {
        return this.brokerRule.getBrokerCfg();
    }

    public ControlledActorClock getBrokerClock() {
        return this.brokerRule.getClock();
    }

    public Statement apply(Statement base, Description description) {
        Statement statement = this.recordingExporterTestWatcher.apply(base, description);
        return super.apply(statement, description);
    }

    protected void before() {
        this.brokerRule.before();
        this.clientRule.before();
    }

    protected void after() {
        this.clientRule.after();
        this.brokerRule.after();
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent processInstance) {
        return ProcessInstanceAssert.assertThat(processInstance);
    }

    public void printProcessInstanceEvents(long key) {
        RecordingExporter.processInstanceRecords().withProcessInstanceKey(key).forEach(event -> System.out.println("> " + event.toJson()));
    }
}

