/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.exporter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.ClientRule;
import io.camunda.zeebe.test.EmbeddedBrokerRule;
import io.camunda.zeebe.test.util.TestConfigurationFactory;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.netty.util.NetUtil;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated(since="1.3.0", forRemoval=true)
public class ExporterIntegrationRule
extends ExternalResource {
    public static final BpmnModelInstance SAMPLE_PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().intermediateCatchEvent("message", e -> e.message(m -> m.name("catch").zeebeCorrelationKeyExpression("orderId"))).serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("work")).zeebeTaskHeader("foo", "bar")).endEvent().done();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(new Consumer[0]);
    private final RecordingExporterTestWatcher testWatcher = new RecordingExporterTestWatcher();
    private ClientRule clientRule;

    public Statement apply(Statement base, Description description) {
        Statement statement = this.testWatcher.apply(base, description);
        return super.apply(statement, description);
    }

    protected void before() throws Throwable {
        super.before();
        if (!this.hasConfiguredExporters()) {
            this.start();
        }
    }

    protected void after() {
        super.after();
        this.stop();
    }

    public BrokerCfg getBrokerConfig() {
        return this.brokerRule.getBrokerCfg();
    }

    public List<ExporterCfg> getConfiguredExporters() {
        return this.getBrokerConfig().getExporters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("test-recorder")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public boolean hasConfiguredExporters() {
        return this.getConfiguredExporters().isEmpty();
    }

    public <T> T getExporterConfiguration(String id, Class<T> configurationClass) {
        return (T)Optional.ofNullable((ExporterCfg)this.getBrokerConfig().getExporters().get(id)).map(cfg -> this.convertMapToConfig(cfg.getArgs(), configurationClass)).orElseThrow(() -> new IllegalArgumentException("No exporter with ID " + id + " configured"));
    }

    public ExporterIntegrationRule configure(InputStream yaml) {
        BrokerCfg config = (BrokerCfg)new TestConfigurationFactory().create(yaml, BrokerCfg.class);
        return this.configure(config.getExporters());
    }

    public <T, E extends Exporter> ExporterIntegrationRule configure(String id, Class<E> exporterClass, T configuration) {
        Map<String, Object> arguments = this.convertConfigToMap(configuration);
        return this.configure(id, exporterClass, arguments);
    }

    public <E extends Exporter> ExporterIntegrationRule configure(String id, Class<E> exporterClass, Map<String, Object> arguments) {
        ExporterCfg config = new ExporterCfg();
        config.setClassName(exporterClass.getCanonicalName());
        config.setArgs(arguments);
        return this.configure(Collections.singletonMap(id, config));
    }

    public void start() {
        if (this.hasConfiguredExporters()) {
            throw new IllegalStateException("No exporter configured!");
        }
        RecordingExporter.setMaximumWaitTime((long)Duration.ofSeconds(10L).toMillis());
        this.brokerRule.startBroker();
        this.clientRule = new ClientRule(this::newClientProperties);
        this.clientRule.createClient();
    }

    public void stop() {
        this.brokerRule.stopBroker();
        if (this.clientRule != null) {
            this.clientRule.destroyClient();
        }
    }

    public void performSampleWorkload() {
        this.deployProcess(SAMPLE_PROCESS, "sample_process.bpmn");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("orderId", "foo-bar-123");
        variables.put("largeValue", "x".repeat(8192));
        variables.put("unicode", "\u00c1");
        long processInstanceKey = this.createProcessInstance("testProcess", variables);
        AtomicBoolean fail = new AtomicBoolean(true);
        JobWorker worker = this.createJobWorker("work", (client, job) -> {
            if (fail.getAndSet(false)) {
                client.newFailCommand(job.getKey()).retries(0).errorMessage("failed").send().join();
            } else {
                client.newCompleteCommand(job.getKey()).send().join();
            }
        });
        this.publishMessage("catch", "foo-bar-123");
        Record incident = (Record)((Optional)Awaitility.await((String)"the incident was created").timeout(Duration.ofMinutes(1L)).until(() -> RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("task").findFirst(), Optional::isPresent)).orElseThrow();
        this.clientRule.getClient().newUpdateRetriesCommand(((IncidentRecordValue)incident.getValue()).getJobKey()).retries(3).send().join();
        this.clientRule.getClient().newResolveIncidentCommand(incident.getKey()).send().join();
        this.awaitProcessCompletion(processInstanceKey);
        worker.close();
    }

    public void visitExportedRecords(Consumer<Record<?>> visitor) {
        RecordingExporter.getRecords().forEach(visitor);
    }

    public void deployProcess(BpmnModelInstance process, String filename) {
        this.clientRule.getClient().newDeployCommand().addProcessModel(process, filename).send().join();
    }

    public long createProcessInstance(String processId, Map<String, Object> variables) {
        return ((ProcessInstanceEvent)this.clientRule.getClient().newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).send().join()).getProcessInstanceKey();
    }

    public JobWorker createJobWorker(String type, JobHandler handler) {
        return this.clientRule.getClient().newWorker().jobType(type).handler(handler).open();
    }

    public void publishMessage(String messageName, String correlationKey) {
        this.clientRule.getClient().newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).send().join();
    }

    public void awaitProcessCompletion(long processInstanceKey) {
        Awaitility.await((String)"the process instance was completed").until(() -> ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).filter(r -> r.getKey() == processInstanceKey)).exists());
    }

    private Properties newClientProperties() {
        Properties properties = new Properties();
        properties.put("zeebe.client.gateway.address", NetUtil.toSocketAddressString((InetSocketAddress)this.getBrokerConfig().getGateway().getNetwork().toSocketAddress()));
        properties.put("zeebe.client.security.plaintext", "true");
        return properties;
    }

    private ExporterIntegrationRule configure(Map<String, ExporterCfg> exporters) {
        this.getBrokerConfig().getExporters().putAll(exporters);
        return this;
    }

    private <T> Map<String, Object> convertConfigToMap(T configuration) {
        return (Map)OBJECT_MAPPER.convertValue(configuration, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private <T> T convertMapToConfig(Map<String, Object> map, Class<T> configClass) {
        return (T)OBJECT_MAPPER.convertValue(map, configClass);
    }
}

