/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.transport.stream.impl.messages;

import org.agrona.DirectBuffer;
import org.agrona.sbe.*;


/**
 * Universally Unique ID
 */
@SuppressWarnings("all")
public final class UUIDDecoder implements CompositeDecoderFlyweight
{
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "8.2.1";
    public static final int ENCODED_LENGTH = 16;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private int offset;
    private DirectBuffer buffer;

    public UUIDDecoder wrap(final DirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;

        return this;
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public int encodedLength()
    {
        return ENCODED_LENGTH;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public static int highEncodingOffset()
    {
        return 0;
    }

    public static int highEncodingLength()
    {
        return 8;
    }

    public static int highSinceVersion()
    {
        return 0;
    }

    public static long highNullValue()
    {
        return -9223372036854775808L;
    }

    public static long highMinValue()
    {
        return -9223372036854775807L;
    }

    public static long highMaxValue()
    {
        return 9223372036854775807L;
    }

    public long high()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int lowEncodingOffset()
    {
        return 8;
    }

    public static int lowEncodingLength()
    {
        return 8;
    }

    public static int lowSinceVersion()
    {
        return 0;
    }

    public static long lowNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lowMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lowMaxValue()
    {
        return 9223372036854775807L;
    }

    public long low()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        builder.append('(');
        builder.append("high=");
        builder.append(this.high());
        builder.append('|');
        builder.append("low=");
        builder.append(this.low());
        builder.append(')');

        return builder;
    }
}
