/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamApiHandler;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamEndpoint;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamServiceImpl;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamerImpl;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.function.Supplier;

public final class TransportFactory {
    private final ActorSchedulingService actorSchedulingService;

    public TransportFactory(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
    }

    public ServerTransport createServerTransport(int nodeId, MessagingService messagingService) {
        AtomixServerTransport atomixServerTransport = new AtomixServerTransport(messagingService);
        this.actorSchedulingService.submitActor((Actor)atomixServerTransport);
        return atomixServerTransport;
    }

    public ClientTransport createClientTransport(MessagingService messagingService) {
        AtomixClientTransportAdapter atomixClientTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        this.actorSchedulingService.submitActor((Actor)atomixClientTransportAdapter);
        return atomixClientTransportAdapter;
    }

    public <M extends BufferReader, P extends BufferWriter> RemoteStreamService<M, P> createRemoteStreamServer(ClusterCommunicationService clusterCommunicationService, Supplier<M> metadataFactory) {
        RemoteStreamRegistry registry = new RemoteStreamRegistry();
        return new RemoteStreamServiceImpl(new RemoteStreamerImpl(clusterCommunicationService, registry), new RemoteStreamEndpoint(clusterCommunicationService, new RemoteStreamApiHandler(registry, metadataFactory)));
    }
}

