/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequestDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.MetaAttribute;
import io.camunda.zeebe.transport.stream.impl.messages.UUIDEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AddStreamRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 400;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "8.2.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AddStreamRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final UUIDEncoder id = new UUIDEncoder();

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 400;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AddStreamRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 16);
        return this;
    }

    public AddStreamRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(16).templateId(400).schemaId(0).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int idId() {
        return 1;
    }

    public static int idSinceVersion() {
        return 0;
    }

    public static int idEncodingOffset() {
        return 0;
    }

    public static int idEncodingLength() {
        return 16;
    }

    public static String idMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UUIDEncoder id() {
        this.id.wrap(this.buffer, this.offset + 0);
        return this.id;
    }

    public static int streamTypeId() {
        return 2;
    }

    public static String streamTypeCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String streamTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamTypeHeaderLength() {
        return 4;
    }

    public AddStreamRequestEncoder putStreamType(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AddStreamRequestEncoder putStreamType(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AddStreamRequestEncoder streamType(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int metadataId() {
        return 3;
    }

    public static String metadataCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String metadataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metadataHeaderLength() {
        return 4;
    }

    public AddStreamRequestEncoder putMetadata(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AddStreamRequestEncoder putMetadata(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AddStreamRequestEncoder metadata(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AddStreamRequestDecoder decoder = new AddStreamRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 16, 1);
        return decoder.appendTo(builder);
    }
}

