/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.camunda.zeebe.transport.stream.api.ClientStreamConsumer;
import io.camunda.zeebe.transport.stream.api.ClientStreamId;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.AggregatedClientStream;
import io.camunda.zeebe.transport.stream.impl.ClientStreamIdImpl;
import io.camunda.zeebe.transport.stream.impl.ClientStreamImpl;
import io.camunda.zeebe.transport.stream.impl.LogicalId;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class ClientStreamRegistry<M extends BufferWriter> {
    private final Map<ClientStreamId, ClientStreamImpl<M>> clientStreams = new HashMap<ClientStreamId, ClientStreamImpl<M>>();
    private final Map<UUID, AggregatedClientStream<M>> serverStreams = new HashMap<UUID, AggregatedClientStream<M>>();
    private final Map<LogicalId<M>, UUID> serverStreamIds = new HashMap<LogicalId<M>, UUID>();
    private final ClientStreamMetrics metrics;

    ClientStreamRegistry() {
        this(ClientStreamMetrics.noop());
    }

    ClientStreamRegistry(ClientStreamMetrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "must specify metrics");
    }

    Optional<AggregatedClientStream<M>> get(UUID serverStreamId) {
        return Optional.ofNullable(this.serverStreams.get(serverStreamId));
    }

    Collection<AggregatedClientStream<M>> list() {
        return this.serverStreams.values();
    }

    ClientStreamImpl<M> addClient(DirectBuffer streamType, M metadata, ClientStreamConsumer clientStreamConsumer) {
        UnsafeBuffer streamTypeBuffer = new UnsafeBuffer(streamType);
        LogicalId logicalId = new LogicalId(streamTypeBuffer, metadata);
        UUID serverStreamId = this.serverStreamIds.computeIfAbsent(logicalId, k -> UUID.randomUUID());
        AggregatedClientStream serverStream = this.serverStreams.computeIfAbsent(serverStreamId, k -> new AggregatedClientStream(serverStreamId, logicalId));
        ClientStreamIdImpl streamId = new ClientStreamIdImpl(serverStreamId, serverStream.nextLocalId());
        ClientStreamImpl<M> clientStream = new ClientStreamImpl<M>(streamId, serverStream, (DirectBuffer)streamTypeBuffer, metadata, clientStreamConsumer);
        serverStream.addClient(clientStream);
        this.clientStreams.put(streamId, clientStream);
        this.metrics.aggregatedStreamCount(this.serverStreams.size());
        this.metrics.clientCount(this.clientStreams.size());
        return clientStream;
    }

    Optional<AggregatedClientStream<M>> removeClient(ClientStreamId streamId) {
        ClientStreamImpl<M> clientStream = this.clientStreams.remove(streamId);
        if (clientStream != null) {
            AggregatedClientStream<M> serverStream = clientStream.serverStream();
            serverStream.removeClient(clientStream.streamId());
            this.metrics.clientCount(this.clientStreams.size());
            if (serverStream.isEmpty()) {
                this.serverStreams.remove(serverStream.streamId());
                this.serverStreamIds.remove(serverStream.logicalId());
                this.metrics.aggregatedStreamCount(this.serverStreams.size());
                return Optional.of(serverStream);
            }
        }
        return Optional.empty();
    }

    void clear() {
        this.clientStreams.clear();
        this.serverStreams.clear();
        this.serverStreamIds.clear();
        this.metrics.clientCount(0);
        this.metrics.aggregatedStreamCount(0);
    }

    Optional<ClientStreamImpl<M>> getClient(ClientStreamId clientStreamId) {
        return Optional.ofNullable(this.clientStreams.get(clientStreamId));
    }
}

