/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.util.buffer.BufferReader;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MessageUtil {
    private MessageUtil() {
    }

    public static PushStreamRequest parsePushRequest(byte[] bytes) {
        return MessageUtil.parseRequest(bytes, new PushStreamRequest());
    }

    public static RemoveStreamRequest parseRemoveRequest(byte[] bytes) {
        return MessageUtil.parseRequest(bytes, new RemoveStreamRequest());
    }

    public static AddStreamRequest parseAddRequest(byte[] bytes) {
        return MessageUtil.parseRequest(bytes, new AddStreamRequest());
    }

    private static <R extends BufferReader> R parseRequest(byte[] bytes, R request) {
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        request.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        return request;
    }
}

