/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponse;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.StreamResponse;
import io.camunda.zeebe.util.Either;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class StreamResponseDecoder {
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final DirectBuffer buffer = new UnsafeBuffer();

    public <T extends StreamResponse> Either<ErrorResponse, T> decode(byte[] bytes, T response) {
        if (bytes.length == 0) {
            return Either.right(response);
        }
        this.buffer.wrap(bytes);
        this.headerDecoder.wrap(this.buffer, 0);
        if (this.headerDecoder.schemaId() != this.headerDecoder.sbeSchemaId()) {
            return Either.left((Object)new ErrorResponse().code(ErrorCode.MALFORMED).message("Invalid schema ID; expected '%d', got '%d'".formatted(this.headerDecoder.sbeSchemaId(), this.headerDecoder.schemaId())));
        }
        if (this.headerDecoder.templateId() == 406) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.wrap(this.buffer, 0, this.buffer.capacity());
            return Either.left((Object)errorResponse);
        }
        if (this.headerDecoder.templateId() != response.templateId()) {
            return Either.left((Object)new ErrorResponse().code(ErrorCode.MALFORMED).message("Invalid template ID; expected '%d', got '%d'".formatted(this.headerDecoder.templateId(), response.templateId())));
        }
        response.wrap(this.buffer, 0, this.buffer.capacity());
        return Either.right(response);
    }
}

