/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.ClientStreamIdImpl;
import io.camunda.zeebe.transport.stream.impl.ClientStreamImpl;
import io.camunda.zeebe.transport.stream.impl.ClientStreamRequestManager;
import io.camunda.zeebe.transport.stream.impl.LogicalId;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.agrona.collections.Int2ObjectHashMap;

final class AggregatedClientStream<M extends BufferWriter> {
    private final UUID streamId;
    private final LogicalId<M> logicalId;
    private final Set<MemberId> liveConnections = new HashSet<MemberId>();
    private final ClientStreamMetrics metrics;
    private final Int2ObjectHashMap<ClientStreamImpl<M>> clientStreams = new Int2ObjectHashMap();
    private boolean isOpened;
    private int nextLocalId;

    AggregatedClientStream(UUID streamId, LogicalId<M> logicalId) {
        this(streamId, logicalId, ClientStreamMetrics.noop());
    }

    AggregatedClientStream(UUID streamId, LogicalId<M> logicalId, ClientStreamMetrics metrics) {
        this.streamId = streamId;
        this.logicalId = logicalId;
        this.metrics = metrics;
    }

    void addClient(ClientStreamImpl<M> clientStream) {
        this.clientStreams.put(clientStream.streamId().localId(), clientStream);
        this.metrics.observeAggregatedClientCount(this.clientStreams.size());
    }

    UUID streamId() {
        return this.streamId;
    }

    Collection<ClientStreamImpl<M>> list() {
        return this.clientStreams.values();
    }

    int nextLocalId() {
        int localId = this.nextLocalId++;
        return localId;
    }

    void add(MemberId serverId) {
        this.liveConnections.add(serverId);
    }

    boolean isConnected(MemberId serverId) {
        return this.liveConnections.contains(serverId);
    }

    void remove(MemberId serverId) {
        this.liveConnections.remove(serverId);
    }

    Int2ObjectHashMap<ClientStreamImpl<M>> clientStreams() {
        return this.clientStreams;
    }

    void close() {
        this.isOpened = false;
    }

    void removeClient(ClientStreamIdImpl streamId) {
        this.clientStreams.remove(streamId.localId());
        this.metrics.observeAggregatedClientCount(this.clientStreams.size());
    }

    boolean isEmpty() {
        return this.clientStreams.isEmpty();
    }

    LogicalId<M> logicalId() {
        return this.logicalId;
    }

    Set<MemberId> liveConnections() {
        return this.liveConnections;
    }

    void open(ClientStreamRequestManager<M> requestManager, Set<MemberId> servers) {
        if (this.isOpened) {
            return;
        }
        requestManager.add(this, servers);
        this.isOpened = true;
    }

    public String toString() {
        return "AggregatedClientStream{streamId=" + String.valueOf(this.streamId) + ", logicalId=" + String.valueOf(this.logicalId) + ", liveConnections=" + String.valueOf(this.liveConnections) + ", clientStreams=" + this.clientStreams.size() + ", isOpened=" + this.isOpened + ", nextLocalId=" + this.nextLocalId + "}";
    }
}

