/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.ClientStreamBlockedException;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.api.NoSuchStreamException;
import io.camunda.zeebe.transport.stream.api.StreamExhaustedException;
import io.camunda.zeebe.transport.stream.impl.AggregatedClientStream;
import io.camunda.zeebe.transport.stream.impl.ClientStreamImpl;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponse;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientStreamPusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStreamPusher.class);
    private static final Logger PUSH_ERROR_LOGGER = new ThrottledLogger(LOGGER, Duration.ofSeconds(1L));
    private final ClientStreamMetrics metrics;

    ClientStreamPusher(ClientStreamMetrics metrics) {
        this.metrics = metrics;
    }

    void push(AggregatedClientStream<?> stream, DirectBuffer payload, ActorFuture<Void> future) {
        Int2ObjectHashMap.ValueCollection streams = stream.clientStreams().values();
        if (streams.isEmpty()) {
            future.completeExceptionally((Throwable)new NoSuchStreamException("Cannot forward remote payload as there is no known client streams for aggregated stream %s".formatted(stream.logicalId())));
            return;
        }
        LinkedList targets = new LinkedList((Collection<ClientStreamImpl<?>>)streams);
        Collections.shuffle(targets);
        this.tryPush(stream.streamId(), targets, payload, future, new ArrayList<Throwable>());
    }

    private void tryPush(UUID streamId, Queue<ClientStreamImpl<?>> targets, DirectBuffer buffer, ActorFuture<Void> future, List<Throwable> errors) {
        ClientStreamImpl<?> clientStream = targets.poll();
        if (clientStream == null) {
            this.failOnStreamExhausted(future, errors);
            return;
        }
        LOGGER.trace("Pushing data from stream [{}] to client [{}]", (Object)streamId, (Object)clientStream.streamId());
        this.push(clientStream, buffer).onComplete((ok, pushFailed) -> {
            if (pushFailed == null) {
                future.complete(null);
                return;
            }
            errors.add((Throwable)pushFailed);
            this.logFailedPush((Throwable)pushFailed, clientStream);
            this.metrics.pushTryFailed(ErrorResponse.mapErrorToCode(pushFailed));
            this.tryPush(streamId, targets, buffer, future, errors);
        });
    }

    private ActorFuture<Void> push(ClientStreamImpl<?> stream, DirectBuffer payload) {
        try {
            return stream.clientStreamConsumer().push(payload);
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
    }

    private void failOnStreamExhausted(ActorFuture<Void> future, List<Throwable> errors) {
        StreamExhaustedException error = new StreamExhaustedException("Failed to push data to all available clients. No more clients left to retry.");
        errors.forEach(error::addSuppressed);
        future.completeExceptionally((Throwable)error);
    }

    private void logFailedPush(Throwable pushFailed, ClientStreamImpl<?> clientStream) {
        if (pushFailed instanceof ClientStreamBlockedException) {
            LOGGER.trace("Failed to push data to client [{}], stream is blocked", (Object)clientStream.streamId());
        } else {
            PUSH_ERROR_LOGGER.warn("Failed to push data to client [{}], retrying with next client.", (Object)clientStream.streamId(), (Object)pushFailed);
        }
    }
}

