/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequestDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequestEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Objects;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class RemoveStreamRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final RemoveStreamRequestEncoder messageEncoder = new RemoveStreamRequestEncoder();
    private final RemoveStreamRequestDecoder messageDecoder = new RemoveStreamRequestDecoder();
    private UUID streamId;

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageDecoder.wrapAndApplyHeader(buffer, 0, this.headerDecoder);
        this.streamId = new UUID(this.messageDecoder.id().high(), this.messageDecoder.id().low());
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.messageEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder);
        if (this.streamId != null) {
            this.messageEncoder.id().high(this.streamId.getMostSignificantBits()).low(this.streamId.getLeastSignificantBits());
        }
    }

    public UUID streamId() {
        return this.streamId;
    }

    public RemoveStreamRequest streamId(UUID streamId) {
        this.streamId = streamId;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.streamId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveStreamRequest that = (RemoveStreamRequest)o;
        return Objects.equals(this.streamId, that.streamId);
    }

    public String toString() {
        return "RemoveStreamRequest{streamId=" + String.valueOf(this.streamId) + "}";
    }
}

