/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.retry;

import io.camunda.zeebe.util.exception.RecoverableException;
import io.camunda.zeebe.util.retry.ActorRetryMechanism;
import io.camunda.zeebe.util.retry.OperationToRetry;
import io.camunda.zeebe.util.retry.RetryStrategy;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.BooleanSupplier;

public final class RecoverableRetryStrategy
implements RetryStrategy {
    private final ActorControl actor;
    private final ActorRetryMechanism retryMechanism;
    private CompletableActorFuture<Boolean> currentFuture;
    private BooleanSupplier terminateCondition;

    public RecoverableRetryStrategy(ActorControl actor) {
        this.actor = actor;
        this.retryMechanism = new ActorRetryMechanism(actor);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier condition) {
        this.currentFuture = new CompletableActorFuture();
        this.terminateCondition = condition;
        this.retryMechanism.wrap(callable, this.terminateCondition, this.currentFuture);
        this.actor.runUntilDone(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            this.retryMechanism.run();
        }
        catch (RecoverableException ex) {
            if (this.terminateCondition.getAsBoolean()) {
                this.actor.done();
            } else {
                this.actor.yieldThread();
            }
        }
        catch (Exception exception) {
            this.currentFuture.completeExceptionally(exception);
            this.actor.done();
        }
    }
}

