/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorTaskQueueHead;
import io.camunda.zeebe.util.sched.ActorTaskQueueNode;
import org.agrona.UnsafeAccess;

public final class ActorTaskQueue
extends ActorTaskQueueHead {
    protected long p31;
    protected long p32;
    protected long p33;
    protected long p34;
    protected long p35;
    protected long p36;
    protected long p37;
    protected long p38;
    protected long p39;
    protected long p40;
    protected long p41;
    protected long p42;
    protected long p43;
    protected long p44;
    protected long p45;
    private final ActorTaskQueueNode empty = new ActorTaskQueueNode();

    public ActorTaskQueue() {
        this.headOrdered(this.empty);
        UnsafeAccess.UNSAFE.putOrderedObject(this, TAIL_OFFSET, this.empty);
    }

    public void append(ActorTask task) {
        ActorTaskQueueNode tail = new ActorTaskQueueNode();
        tail.task = task;
        tail.stateCount = task.getStateCount();
        ActorTaskQueueNode previousTail = this.swapTail(tail);
        previousTail.nextOrdered(tail);
        tail.prevOrdered(previousTail);
    }

    public ActorTask trySteal() {
        ActorTaskQueueNode node = this.tail;
        while (node != null && node != this.empty) {
            ActorTask task = node.task;
            if (task.claim(node.stateCount)) {
                return task;
            }
            node = node.prev;
        }
        return null;
    }

    public ActorTask pop() {
        ActorTask task = null;
        ActorTaskQueueNode node = null;
        do {
            ActorTask t;
            if ((node = this.poll()) == this.empty || node == null || !(t = node.task).claim(node.stateCount)) continue;
            task = t;
            break;
        } while (node != null && node != this.empty);
        return task;
    }

    private ActorTaskQueueNode poll() {
        ActorTaskQueueNode value = null;
        ActorTaskQueueNode head = this.head;
        ActorTaskQueueNode next = head.next;
        if (null != next) {
            ActorTaskQueueNode tail;
            value = next;
            head.prevOrdered(null);
            head.nextOrdered(null);
            if (null == next.next && (tail = this.tail) == next && this.casTail(tail, this.empty)) {
                next = this.empty;
            }
            this.headOrdered(next);
        }
        return value;
    }

    public ActorTaskQueueNode peek() {
        ActorTaskQueueNode next = this.head.next;
        return next == this.empty ? null : next;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    private void headOrdered(ActorTaskQueueNode head) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, HEAD_OFFSET, head);
    }

    private ActorTaskQueueNode swapTail(ActorTaskQueueNode newTail) {
        return (ActorTaskQueueNode)UnsafeAccess.UNSAFE.getAndSetObject(this, TAIL_OFFSET, newTail);
    }

    private boolean casTail(ActorTaskQueueNode expectedNode, ActorTaskQueueNode updateNode) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, TAIL_OFFSET, expectedNode, updateNode);
    }
}

