/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSubscription;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorThread;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.concurrent.Callable;

public final class ActorJob {
    ActorTask.TaskSchedulingState schedulingState;
    Actor actor;
    ActorTask task;
    ActorThread actorThread;
    private Callable<?> callable;
    private Runnable runnable;
    private Object invocationResult;
    private boolean isAutoCompleting;
    private boolean isDoneCalled;
    private ActorFuture resultFuture;
    private ActorSubscription subscription;

    public void onJobAddedToTask(ActorTask task) {
        this.actor = task.actor;
        this.task = task;
        this.schedulingState = ActorTask.TaskSchedulingState.QUEUED;
    }

    void execute(ActorThread runner) {
        this.actorThread = runner;
        try {
            this.invoke();
            if (this.resultFuture != null) {
                this.resultFuture.complete(this.invocationResult);
                this.resultFuture = null;
            }
        }
        catch (Exception e) {
            this.task.onFailure(e);
        }
        finally {
            this.actorThread = null;
            this.schedulingState = this.isTriggeredBySubscription() || this.isAutoCompleting && this.runnable == null || this.isDoneCalled ? ActorTask.TaskSchedulingState.TERMINATED : ActorTask.TaskSchedulingState.QUEUED;
        }
    }

    private void invoke() throws Exception {
        if (this.callable != null) {
            this.invocationResult = this.callable.call();
        } else if (!this.isTriggeredBySubscription()) {
            while (this.runnable != null && !this.task.shouldYield && !this.isDoneCalled) {
                Runnable r = this.runnable;
                if (this.isAutoCompleting) {
                    this.runnable = null;
                }
                r.run();
            }
        } else {
            this.runnable.run();
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public ActorFuture setCallable(Callable<?> callable) {
        this.callable = callable;
        this.setResultFuture(new CompletableActorFuture());
        return this.resultFuture;
    }

    void reset() {
        this.schedulingState = ActorTask.TaskSchedulingState.NOT_SCHEDULED;
        this.actor = null;
        this.task = null;
        this.actorThread = null;
        this.callable = null;
        this.runnable = null;
        this.invocationResult = null;
        this.isAutoCompleting = true;
        this.isDoneCalled = false;
        this.resultFuture = null;
        this.subscription = null;
    }

    public void markDone() {
        if (this.isAutoCompleting) {
            throw new UnsupportedOperationException("Incorrect use of actor.done(). Can only be called in methods submitted using actor.runUntilDone(Runnable r)");
        }
        this.isDoneCalled = true;
    }

    public void setAutoCompleting(boolean isAutoCompleting) {
        this.isAutoCompleting = isAutoCompleting;
    }

    public String toString() {
        Object toString = "";
        if (this.runnable != null) {
            toString = (String)toString + this.runnable.getClass().getName();
        }
        if (this.callable != null) {
            toString = (String)toString + this.callable.getClass().getName();
        }
        toString = (String)toString + " " + this.schedulingState;
        return toString;
    }

    public boolean isTriggeredBySubscription() {
        return this.subscription != null;
    }

    public ActorSubscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(ActorSubscription subscription) {
        this.subscription = subscription;
        this.task.addSubscription(subscription);
    }

    public ActorTask getTask() {
        return this.task;
    }

    public Actor getActor() {
        return this.actor;
    }

    public void setResultFuture(ActorFuture resultFuture) {
        assert (!resultFuture.isDone());
        this.resultFuture = resultFuture;
    }

    public void failFuture(String reason) {
        this.failFuture(new RuntimeException(reason));
    }

    public void failFuture(Throwable cause) {
        if (this.resultFuture != null) {
            this.resultFuture.completeExceptionally(cause);
        }
    }
}

