/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched.future;

import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.function.BiConsumer;
import org.agrona.LangUtil;

public final class FutureContinuationRunnable<T>
implements Runnable {
    private final ActorFuture<T> future;
    private final BiConsumer<T, Throwable> consumer;

    public FutureContinuationRunnable(ActorFuture<T> future, BiConsumer<T, Throwable> consumer) {
        this.future = future;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        if (!this.future.isCompletedExceptionally()) {
            try {
                Object res = this.future.get();
                this.consumer.accept(res, null);
            }
            catch (Exception e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        } else {
            this.consumer.accept(null, this.future.getException());
        }
    }
}

