/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.AsyncClosable;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class Actor
implements CloseableSilently,
AsyncClosable,
ConcurrencyControl {
    public static final String ACTOR_PROP_NAME = "actor-name";
    public static final String ACTOR_PROP_PARTITION_ID = "partitionId";
    private static final int MAX_CLOSE_TIMEOUT = 300;
    protected final ActorControl actor = new ActorControl(this);
    private Map<String, String> context;

    protected Map<String, String> createContext() {
        HashMap<String, String> baseContext = new HashMap<String, String>();
        baseContext.put(ACTOR_PROP_NAME, this.getName());
        return baseContext;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Map<String, String> getContext() {
        if (this.context == null) {
            this.context = Collections.unmodifiableMap(this.createContext());
        }
        return this.context;
    }

    public boolean isActorClosed() {
        return this.actor.isClosed();
    }

    protected void onActorStarting() {
    }

    protected void onActorStarted() {
    }

    protected void onActorClosing() {
    }

    protected void onActorClosed() {
    }

    protected void onActorCloseRequested() {
    }

    public static Actor wrap(final Consumer<ActorControl> r) {
        return new Actor(){

            @Override
            public String getName() {
                return r.toString();
            }

            @Override
            protected void onActorStarted() {
                r.accept(this.actor);
            }
        };
    }

    @Override
    public void close() {
        this.closeAsync().join(300L, TimeUnit.SECONDS);
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        return this.actor.close();
    }

    public static String buildActorName(int nodeId, String name) {
        return String.format("Broker-%d-%s", nodeId, name);
    }

    public static String buildActorName(int nodeId, String name, int partitionId) {
        return String.format("Broker-%d-%s-%d", nodeId, name, partitionId);
    }

    protected void handleFailure(Exception failure) {
        Loggers.ACTOR_LOGGER.error("Uncaught exception in '{}' in phase '{}'. Continuing with next job.", new Object[]{this.getName(), this.actor.getLifecyclePhase(), failure});
    }

    public void onActorFailed() {
    }

    @Override
    public <T> void runOnCompletion(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.actor.runOnCompletion(future, callback);
    }

    @Override
    public void run(Runnable action) {
        this.actor.run(action);
    }
}

