/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.BoundedArrayQueue;
import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import io.camunda.zeebe.util.sched.ActorJob;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorThreadGroup;
import io.camunda.zeebe.util.sched.ActorTimerQueue;
import io.camunda.zeebe.util.sched.TaskScheduler;
import io.camunda.zeebe.util.sched.TimerSubscription;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.DefaultActorClock;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.slf4j.Logger;
import org.slf4j.MDC;
import sun.misc.Unsafe;

public class ActorThread
extends Thread
implements Consumer<Runnable> {
    static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    private static final long STATE_OFFSET;
    private static final Logger LOG;
    private static final FatalErrorHandler FATAL_ERROR_HANDLER;
    public final ManyToManyConcurrentArrayQueue<Runnable> submittedCallbacks = new ManyToManyConcurrentArrayQueue(24576);
    protected final ActorTimerQueue timerJobQueue;
    protected ActorTaskRunnerIdleStrategy idleStrategy = new ActorTaskRunnerIdleStrategy();
    ActorTask currentTask;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final ActorClock clock;
    private final int threadId;
    private final TaskScheduler taskScheduler;
    private final BoundedArrayQueue<ActorJob> jobs = new BoundedArrayQueue(2048);
    private final ActorThreadGroup actorThreadGroup;
    private volatile ActorThreadState state;

    public ActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue) {
        this.setName(name);
        this.state = ActorThreadState.NEW;
        this.threadId = id;
        this.clock = clock != null ? clock : new DefaultActorClock();
        this.timerJobQueue = timerQueue != null ? timerQueue : new ActorTimerQueue(this.clock);
        this.actorThreadGroup = threadGroup;
        this.taskScheduler = taskScheduler;
    }

    private void doWork() {
        this.submittedCallbacks.drain((Consumer)this);
        if (this.clock.update()) {
            this.timerJobQueue.processExpiredTimers(this.clock);
        }
        this.currentTask = this.taskScheduler.getNextTask(this.clock);
        if (this.currentTask != null) {
            try {
                this.executeCurrentTask();
            }
            finally {
                this.taskScheduler.onTaskReleased(this.currentTask);
            }
        } else {
            this.idleStrategy.onIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCurrentTask() {
        Map<String, String> properties = this.currentTask.getActor().getContext();
        MDC.setContextMap(properties);
        this.idleStrategy.onTaskExecuted();
        boolean resubmit = false;
        try {
            resubmit = this.currentTask.execute(this);
        }
        catch (Throwable e) {
            FATAL_ERROR_HANDLER.handleError(e);
            LOG.error("Unexpected error occurred in task {}", (Object)this.currentTask, (Object)e);
        }
        finally {
            MDC.remove((String)"actor-name");
            this.clock.update();
        }
        if (resubmit) {
            this.currentTask.resubmit();
        }
    }

    public void hintWorkAvailable() {
        this.idleStrategy.hintWorkAvailable();
    }

    public void scheduleTimer(TimerSubscription timer) {
        this.timerJobQueue.schedule(timer, this.clock);
    }

    public void removeTimer(TimerSubscription timer) {
        this.timerJobQueue.remove(timer);
    }

    public static ActorThread current() {
        return Thread.currentThread() instanceof ActorThread ? (ActorThread)Thread.currentThread() : null;
    }

    public static ActorThread ensureCalledFromActorThread(String methodName) {
        ActorThread thread = ActorThread.current();
        if (thread == null) {
            throw new UnsupportedOperationException("Incorrect usage of actor. " + methodName + ": must be called from actor thread");
        }
        return thread;
    }

    public ActorJob newJob() {
        ActorJob job = this.jobs.poll();
        if (job == null) {
            job = new ActorJob();
        }
        return job;
    }

    void recycleJob(ActorJob j) {
        j.reset();
        this.jobs.offer(j);
    }

    public int getRunnerId() {
        return this.threadId;
    }

    @Override
    public synchronized void start() {
        if (!UNSAFE.compareAndSwapObject(this, STATE_OFFSET, (Object)ActorThreadState.NEW, (Object)ActorThreadState.RUNNING)) {
            throw new IllegalStateException("Cannot start runner, not in state 'NEW'.");
        }
        super.start();
    }

    @Override
    public void run() {
        this.idleStrategy.init();
        while (this.state == ActorThreadState.RUNNING) {
            try {
                this.doWork();
            }
            catch (Exception e) {
                LOG.error("Unexpected error occurred while in the actor thread {}", (Object)this.getName(), (Object)e);
            }
        }
        this.state = ActorThreadState.TERMINATED;
        this.terminationFuture.complete(null);
    }

    public CompletableFuture<Void> close() {
        if (UNSAFE.compareAndSwapObject(this, STATE_OFFSET, (Object)ActorThreadState.RUNNING, (Object)ActorThreadState.TERMINATING)) {
            return this.terminationFuture;
        }
        throw new IllegalStateException("Cannot stop runner, not in state 'RUNNING'.");
    }

    public ActorJob getCurrentJob() {
        ActorTask task = this.getCurrentTask();
        if (task != null) {
            return task.currentJob;
        }
        return null;
    }

    public ActorTask getCurrentTask() {
        return this.currentTask;
    }

    public ActorClock getClock() {
        return this.clock;
    }

    public ActorThreadGroup getActorThreadGroup() {
        return this.actorThreadGroup;
    }

    @Override
    public void accept(Runnable t) {
        t.run();
    }

    static {
        LOG = Loggers.ACTOR_LOGGER;
        FATAL_ERROR_HANDLER = FatalErrorHandler.withLogger(LOG);
        try {
            STATE_OFFSET = UNSAFE.objectFieldOffset(ActorThread.class.getDeclaredField("state"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected class ActorTaskRunnerIdleStrategy {
        final BackoffIdleStrategy backoff = new BackoffIdleStrategy(100L, 100L, 1L, TimeUnit.MILLISECONDS.toNanos(1L));
        boolean isIdle;
        long idleTimeStart;
        long busyTimeStart;

        protected ActorTaskRunnerIdleStrategy() {
        }

        void init() {
            this.isIdle = true;
            this.idleTimeStart = System.nanoTime();
        }

        public void hintWorkAvailable() {
            LockSupport.unpark(ActorThread.this);
        }

        protected void onIdle() {
            if (!this.isIdle) {
                ActorThread.this.clock.update();
                this.idleTimeStart = ActorThread.this.clock.getNanoTime();
                this.isIdle = true;
            }
            this.backoff.idle();
        }

        protected void onTaskExecuted() {
            this.backoff.reset();
            if (this.isIdle) {
                this.busyTimeStart = ActorThread.this.clock.getNanoTime();
                this.isIdle = false;
            }
        }
    }

    public static enum ActorThreadState {
        NEW,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }
}

