/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import io.camunda.zeebe.util.health.HealthIssue;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.StringJoiner;

public final class HealthReport {
    private final HealthMonitorable component;
    private final String componentName;
    private final HealthStatus status;
    private final HealthIssue issue;

    private HealthReport(HealthMonitorable component, HealthStatus status, HealthIssue issue) {
        this(component, component.getName(), status, issue);
    }

    private HealthReport(HealthMonitorable component, String componentName, HealthStatus status, HealthIssue issue) {
        this.component = component;
        this.componentName = componentName;
        this.status = status;
        this.issue = issue;
    }

    public static HealthReport unknown(String componentName) {
        return new HealthReport(null, componentName, HealthStatus.UNHEALTHY, null);
    }

    public static HealthReport healthy(HealthMonitorable component) {
        return new HealthReport(component, HealthStatus.HEALTHY, null);
    }

    public static HealthReportBuilder unhealthy(HealthMonitorable component) {
        return new HealthReportBuilder(component, HealthStatus.UNHEALTHY);
    }

    public static HealthReportBuilder dead(HealthMonitorable component) {
        return new HealthReportBuilder(component, HealthStatus.DEAD);
    }

    public boolean isHealthy() {
        return this.status == HealthStatus.HEALTHY;
    }

    public boolean isNotHealthy() {
        return this.status != HealthStatus.HEALTHY;
    }

    public boolean isUnhealthy() {
        return this.status == HealthStatus.UNHEALTHY;
    }

    public boolean isDead() {
        return this.status == HealthStatus.DEAD;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public HealthStatus getStatus() {
        return this.status;
    }

    public HealthIssue getIssue() {
        return this.issue;
    }

    public String toString() {
        String name = this.componentName == null ? this.component.getName() : this.componentName;
        StringJoiner joiner = new StringJoiner(", ", name + "{", "}").add("status=" + this.status);
        if (this.issue != null) {
            joiner.add("issue=" + this.issue);
        }
        return joiner.toString();
    }

    public static final class HealthReportBuilder {
        private final HealthMonitorable component;
        private final HealthStatus status;

        private HealthReportBuilder(HealthMonitorable component, HealthStatus status) {
            this.component = component;
            this.status = status;
        }

        public HealthReport withIssue(HealthIssue issue) {
            return new HealthReport(this.component, this.status, issue);
        }

        public HealthReport withMessage(String message) {
            return new HealthReport(this.component, this.status, HealthIssue.of(message));
        }

        public HealthReport withIssue(Throwable e) {
            return new HealthReport(this.component, this.status, HealthIssue.of(e));
        }

        public HealthReport withIssue(HealthReport cause) {
            return new HealthReport(this.component, this.status, HealthIssue.of(cause));
        }
    }
}

