/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorJob;
import io.camunda.zeebe.util.sched.ActorSubscription;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.future.ActorFuture;

public final class ActorFutureSubscription
implements ActorSubscription {
    private final ActorJob callbackJob;
    private final int phaseMask;
    private final ActorFuture<?> future;

    public ActorFutureSubscription(ActorFuture<?> future, ActorJob callbackJob, int phaseMask) {
        this.future = future;
        this.callbackJob = callbackJob;
        this.phaseMask = phaseMask;
    }

    @Override
    public boolean triggersInPhase(ActorTask.ActorLifecyclePhase phase) {
        return phase != ActorTask.ActorLifecyclePhase.CLOSED && (phase.getValue() & this.phaseMask) > 0;
    }

    @Override
    public boolean poll() {
        return this.future.isDone();
    }

    @Override
    public ActorJob getJob() {
        return this.callbackJob;
    }

    @Override
    public boolean isRecurring() {
        return false;
    }
}

