/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched.testing;

import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorThread;
import io.camunda.zeebe.util.sched.ActorThreadGroup;
import io.camunda.zeebe.util.sched.ActorTimerQueue;
import io.camunda.zeebe.util.sched.TaskScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import io.camunda.zeebe.util.sched.testing.ControlledActorThread;
import java.util.concurrent.Callable;
import org.junit.rules.ExternalResource;

public final class ControlledActorSchedulerRule
extends ExternalResource {
    private final ActorScheduler actorScheduler;
    private final ControlledActorThread controlledActorTaskRunner;
    private final ControlledActorClock clock = new ControlledActorClock();

    public ControlledActorSchedulerRule() {
        ControlledActorThreadFactory actorTaskRunnerFactory = new ControlledActorThreadFactory();
        ActorTimerQueue timerQueue = new ActorTimerQueue(this.clock, 1);
        ActorScheduler.ActorSchedulerBuilder builder = ActorScheduler.newActorScheduler().setActorClock(this.clock).setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(0).setActorThreadFactory(actorTaskRunnerFactory).setActorTimerQueue(timerQueue);
        this.actorScheduler = builder.build();
        this.controlledActorTaskRunner = actorTaskRunnerFactory.controlledThread;
    }

    protected void before() {
        this.actorScheduler.start();
    }

    protected void after() {
        this.actorScheduler.stop();
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public ActorScheduler get() {
        return this.actorScheduler;
    }

    public void workUntilDone() {
        this.controlledActorTaskRunner.workUntilDone();
    }

    public <T> ActorFuture<T> call(Callable<T> callable) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.submitActor(new CallingActor(future, callable));
        return future;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    static class ControlledActorThreadFactory
    implements ActorScheduler.ActorThreadFactory {
        private ControlledActorThread controlledThread;

        ControlledActorThreadFactory() {
        }

        @Override
        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue) {
            this.controlledThread = new ControlledActorThread(name, id, threadGroup, taskScheduler, clock, timerQueue);
            return this.controlledThread;
        }
    }

    static class CallingActor<T>
    extends Actor {
        private final ActorFuture<T> future;
        private final Callable<T> callable;

        CallingActor(ActorFuture<T> future, Callable<T> callable) {
            this.future = future;
            this.callable = callable;
        }

        @Override
        protected void onActorStarted() {
            this.actor.run(() -> {
                try {
                    this.future.complete(this.callable.call());
                }
                catch (Exception e) {
                    this.future.completeExceptionally(e);
                }
            });
        }
    }
}

