/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.retry;

import io.camunda.zeebe.util.retry.OperationToRetry;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.function.BooleanSupplier;

public final class ActorRetryMechanism {
    private final ActorControl actor;
    private OperationToRetry currentCallable;
    private BooleanSupplier currentTerminateCondition;
    private ActorFuture<Boolean> currentFuture;

    public ActorRetryMechanism(ActorControl actor) {
        this.actor = actor;
    }

    void wrap(OperationToRetry callable, BooleanSupplier condition, ActorFuture<Boolean> resultFuture) {
        this.currentCallable = callable;
        this.currentTerminateCondition = condition;
        this.currentFuture = resultFuture;
    }

    Control run() throws Exception {
        if (this.currentCallable.run()) {
            this.currentFuture.complete(true);
            return Control.DONE;
        }
        if (this.currentTerminateCondition.getAsBoolean()) {
            this.currentFuture.complete(false);
            return Control.DONE;
        }
        return Control.RETRY;
    }

    static enum Control {
        RETRY,
        DONE;

    }
}

