/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.springframework.util.unit.DataSize;

public class ObjectWriterFactory {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter DEFAULT_JSON_OBJECT_WRITER;

    public static ObjectWriter getDefaultJsonObjectWriter() {
        return DEFAULT_JSON_OBJECT_WRITER;
    }

    static {
        DEFAULT_OBJECT_MAPPER.registerModule((Module)new CustomModule());
        DEFAULT_OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        DEFAULT_OBJECT_MAPPER.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        DEFAULT_JSON_OBJECT_WRITER = DEFAULT_OBJECT_MAPPER.writerWithDefaultPrettyPrinter();
    }

    private static final class CustomModule
    extends SimpleModule {
        private CustomModule() {
            super(CustomModule.class.getName(), PackageVersion.VERSION);
            this.addSerializer(DataSize.class, (JsonSerializer)new DataSizeSerializer());
            this.addSerializer(Map.class, (JsonSerializer)new MapSerializer());
        }
    }

    private static final class MapSerializer
    extends StdSerializer<Map> {
        private MapSerializer() {
            super(Map.class);
        }

        public void serialize(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                String key = entry.getKey().toString();
                jsonGenerator.writeFieldName(key);
                if (key.equals("username") || key.equals("password")) {
                    jsonGenerator.writeString("***");
                    continue;
                }
                jsonGenerator.writeObject(entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    private static final class DataSizeSerializer
    extends StdSerializer<DataSize> {
        private DataSizeSerializer() {
            super(DataSize.class);
        }

        public void serialize(DataSize dataSize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (dataSize.toMegabytes() > 0L) {
                jsonGenerator.writeString(dataSize.toMegabytes() + "MB");
            } else if (dataSize.toKilobytes() > 0L) {
                jsonGenerator.writeString(dataSize.toKilobytes() + "KB");
            } else {
                jsonGenerator.writeString(dataSize.toBytes() + "B");
            }
        }
    }
}

