/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.allocation;

import io.camunda.zeebe.util.CloseableSilently;
import java.nio.ByteBuffer;

public abstract class AllocatedBuffer
implements CloseableSilently {
    protected ByteBuffer rawBuffer;
    private volatile boolean closed;

    public AllocatedBuffer(ByteBuffer buffer) {
        this.rawBuffer = buffer;
        this.closed = false;
    }

    public ByteBuffer getRawBuffer() {
        return this.rawBuffer;
    }

    public int capacity() {
        return this.rawBuffer.capacity();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.doClose();
            this.rawBuffer = null;
        }
    }

    public void doClose() {
    }
}

