/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.logging;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ThrottledLogger
implements Logger {
    private long lastLogTime = 0L;
    private final Logger log;
    private final long intervalMillis;

    public ThrottledLogger(Logger log, Duration interval) {
        this.log = log;
        this.intervalMillis = interval.toMillis();
    }

    public String getName() {
        return this.log.getName();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void trace(String s) {
        this.checkAndLog(() -> this.log.trace(s));
    }

    public void trace(String s, Object o) {
        this.checkAndLog(() -> this.log.trace(s, o));
    }

    public void trace(String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.trace(s, o, o1));
    }

    public void trace(String s, Object ... objects) {
        this.checkAndLog(() -> this.log.trace(s, objects));
    }

    public void trace(String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.trace(s, throwable));
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.log.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        this.checkAndLog(() -> this.log.trace(marker, s));
    }

    public void trace(Marker marker, String s, Object o) {
        this.checkAndLog(() -> this.log.trace(marker, s, o));
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.trace(marker, s, o, o1));
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.checkAndLog(() -> this.log.trace(marker, s, objects));
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.trace(marker, s, throwable));
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String s) {
        this.checkAndLog(() -> this.log.debug(s));
    }

    public void debug(String s, Object o) {
        this.checkAndLog(() -> this.log.debug(s, o));
    }

    public void debug(String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.debug(s, o, o1));
    }

    public void debug(String s, Object ... objects) {
        this.checkAndLog(() -> this.log.debug(s, objects));
    }

    public void debug(String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.debug(s, throwable));
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.log.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        this.checkAndLog(() -> this.log.debug(marker, s));
    }

    public void debug(Marker marker, String s, Object o) {
        this.checkAndLog(() -> this.log.debug(marker, s, o));
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.debug(marker, s, o, o1));
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.checkAndLog(() -> this.log.debug(marker, s, objects));
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.debug(marker, s, throwable));
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String s) {
        this.checkAndLog(() -> this.log.info(s));
    }

    public void info(String s, Object o) {
        this.checkAndLog(() -> this.log.info(s, o));
    }

    public void info(String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.info(s, o, o1));
    }

    public void info(String s, Object ... objects) {
        this.checkAndLog(() -> this.log.info(s, objects));
    }

    public void info(String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.info(s, throwable));
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.log.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        this.checkAndLog(() -> this.log.info(marker, s));
    }

    public void info(Marker marker, String s, Object o) {
        this.checkAndLog(() -> this.log.info(marker, s, o));
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.info(marker, s, o, o1));
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.checkAndLog(() -> this.log.info(marker, s, objects));
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.info(marker, s, throwable));
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String s) {
        this.checkAndLog(() -> this.log.warn(s));
    }

    public void warn(String s, Object o) {
        this.checkAndLog(() -> this.log.warn(s, o));
    }

    public void warn(String s, Object ... objects) {
        this.checkAndLog(() -> this.log.warn(s, objects));
    }

    public void warn(String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.warn(s, o, o1));
    }

    public void warn(String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.warn(s, throwable));
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.log.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        this.checkAndLog(() -> this.log.warn(marker, s));
    }

    public void warn(Marker marker, String s, Object o) {
        this.checkAndLog(() -> this.log.warn(marker, s, o));
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.warn(marker, s, o, o1));
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.checkAndLog(() -> this.log.warn(marker, s, objects));
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.warn(marker, s, throwable));
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String s) {
        this.checkAndLog(() -> this.log.error(s));
    }

    public void error(String s, Object o) {
        this.checkAndLog(() -> this.log.error(s, o));
    }

    public void error(String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.error(s, o, o1));
    }

    public void error(String s, Object ... objects) {
        this.checkAndLog(() -> this.log.error(s, objects));
    }

    public void error(String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.error(s, throwable));
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.log.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        this.checkAndLog(() -> this.log.error(marker, s));
    }

    public void error(Marker marker, String s, Object o) {
        this.checkAndLog(() -> this.log.error(marker, s, o));
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.checkAndLog(() -> this.log.error(marker, s, o, o1));
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.checkAndLog(() -> this.log.error(marker, s, objects));
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.checkAndLog(() -> this.log.error(marker, s, throwable));
    }

    private void checkAndLog(Runnable logger) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime >= this.intervalMillis) {
            logger.run();
            this.lastLogTime = currentTime;
        }
    }
}

