/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Failed to instantiate class %s with the default constructor", clazz.getName()), e);
        }
    }

    public static <T> Stream<Class<T>> implementationsOfSealedInterface(Class<T> clazz) {
        if (!clazz.isSealed()) {
            throw new IllegalArgumentException(String.format("Class %s is not sealed", clazz.getName()));
        }
        return Stream.of(clazz.getPermittedSubclasses()).flatMap(c -> {
            if (c.isSealed()) {
                return ReflectUtil.implementationsOfSealedInterface(c);
            }
            return Stream.of(c);
        });
    }
}

