/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.ExponentialBackoff;
import io.camunda.zeebe.util.RetryDelayStrategy;
import java.time.Duration;

public class ExponentialBackoffRetryDelay
implements RetryDelayStrategy {
    private final ExponentialBackoff exponentialBackoff;
    private long currentDelay = 0L;

    public ExponentialBackoffRetryDelay(Duration maxDelay, Duration minDelay) {
        this.exponentialBackoff = new ExponentialBackoff(maxDelay.toMillis(), minDelay.toMillis());
    }

    @Override
    public Duration nextDelay() {
        this.currentDelay = this.exponentialBackoff.supplyRetryDelay(this.currentDelay);
        return Duration.ofMillis(this.currentDelay);
    }

    @Override
    public void reset() {
        this.currentDelay = 0L;
    }
}

