/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Failed to instantiate class %s with the default constructor", clazz.getName()), e);
        }
    }

    public static <M extends AccessibleObject, U> M makeAccessible(M member, U instance) {
        boolean canAccess;
        block3: {
            canAccess = false;
            try {
                canAccess = member.canAccess(instance);
            }
            catch (IllegalArgumentException e) {
                int modifiers = ((Member)((Object)member)).getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(((Member)((Object)member)).getDeclaringClass().getModifiers())) break block3;
                canAccess = true;
            }
        }
        if (!canAccess) {
            member.setAccessible(true);
        }
        return member;
    }

    public static <T> Stream<Class<T>> implementationsOfSealedInterface(Class<T> clazz) {
        if (!clazz.isSealed()) {
            throw new IllegalArgumentException(String.format("Class %s is not sealed", clazz.getName()));
        }
        return Stream.of(clazz.getPermittedSubclasses()).flatMap(c -> {
            if (c.isSealed()) {
                return ReflectUtil.implementationsOfSealedInterface(c);
            }
            return Stream.of(c);
        });
    }
}

