/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public final class MicrometerUtil {
    private static final Duration[] DEFAULT_PROMETHEUS_BUCKETS = new Duration[]{Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(25L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(75L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofMillis(750L), Duration.ofSeconds(1L), Duration.ofMillis(2500L), Duration.ofSeconds(5L), Duration.ofMillis(7500L), Duration.ofSeconds(10L)};

    private MicrometerUtil() {
    }

    public static Duration[] defaultPrometheusBuckets() {
        return DEFAULT_PROMETHEUS_BUCKETS;
    }

    public static CloseableSilently timer(Timer timer, Timer.Sample sample) {
        return new CloseableTimer(timer, sample);
    }

    public static CloseableSilently timer(LongConsumer setter, TimeUnit unit, Clock clock) {
        return new CloseableGaugeTimer(setter, unit, clock, clock.monotonicTime());
    }

    public static CompositeMeterRegistry wrap(MeterRegistry wrapped, Tags tags) {
        CompositeMeterRegistry registry = wrapped != null ? new CompositeMeterRegistry(wrapped.config().clock(), Collections.singleton(wrapped)) : new CompositeMeterRegistry();
        registry.config().commonTags((Iterable)tags);
        return registry;
    }

    public static Timer.Builder buildTimer(ExtendedMeterDocumentation documentation) {
        return Timer.builder((String)documentation.getName()).description(documentation.getDescription()).serviceLevelObjectives(documentation.getTimerSLOs());
    }

    public static DistributionSummary.Builder summary(ExtendedMeterDocumentation documentation) {
        return DistributionSummary.builder((String)documentation.getName()).description(documentation.getDescription()).serviceLevelObjectives(documentation.getDistributionSLOs());
    }

    public static Duration[] exponentialBucketDuration(long start, long factor, int count, TemporalUnit unit) {
        if (count < 1) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        ArrayList<Duration> buckets = new ArrayList<Duration>(count);
        long value = start;
        for (int i = 0; i < count; ++i) {
            Duration duration = Duration.of(value, unit);
            buckets.add(duration);
            if (Long.MAX_VALUE / factor < value) break;
            value *= factor;
        }
        return (Duration[])buckets.toArray(Duration[]::new);
    }

    public static void discard(CompositeMeterRegistry registry) {
        registry.clear();
        registry.getRegistries().forEach(arg_0 -> ((CompositeMeterRegistry)registry).remove(arg_0));
        registry.close();
    }

    private record CloseableTimer(Timer timer, Timer.Sample sample) implements CloseableSilently
    {
        @Override
        public void close() {
            this.sample.stop(this.timer);
        }
    }

    private record CloseableGaugeTimer(LongConsumer setter, TimeUnit unit, Clock clock, long startNanos) implements CloseableSilently
    {
        @Override
        public void close() {
            this.setter.accept(this.unit.convert(this.clock.monotonicTime() - this.startNanos, TimeUnit.NANOSECONDS));
        }
    }

    public static enum PartitionKeyNames implements KeyName
    {
        PARTITION{

            public String asString() {
                return "partition";
            }
        };


        public static Tags tags(int partitionId) {
            return Tags.of((String)PARTITION.asString(), (String)String.valueOf(partitionId));
        }
    }
}

